/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.namenode.AclEntryStatusFormat;
import org.apache.hadoop.hdfs.server.namenode.AclFeature;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributeProvider;
import org.apache.hadoop.hdfs.server.namenode.INodeAttributes;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.XAttrFeature;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.hdfs.SentryAuthorizationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryINodeAttributesProvider
extends INodeAttributeProvider
implements Configurable {
    private static Logger LOG = LoggerFactory.getLogger(SentryINodeAttributesProvider.class);
    private boolean started;
    private SentryAuthorizationInfo authzInfo;
    private String user;
    private String group;
    private FsPermission permission;
    private boolean originalAuthzAsAcl;
    private Configuration conf;

    public SentryINodeAttributesProvider() {
    }

    private boolean isSentryManaged(String[] pathElements) {
        return this.authzInfo.isSentryManaged(pathElements);
    }

    @VisibleForTesting
    SentryINodeAttributesProvider(SentryAuthorizationInfo authzInfo) {
        this.authzInfo = authzInfo;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Provider already started");
        }
        this.started = true;
        try {
            if (!this.conf.getBoolean("dfs.namenode.acls.enabled", false)) {
                throw new RuntimeException("HDFS ACLs must be enabled");
            }
            Configuration conf = new Configuration(this.conf);
            conf.addResource("hdfs-sentry.xml", true);
            this.user = conf.get("sentry.authorization-provider.hdfs-user", "hive");
            this.group = conf.get("sentry.authorization-provider.hdfs-group", "hive");
            this.permission = FsPermission.createImmutable((short)((short)conf.getLong("sentry.authorization-provider.hdfs-permission", 505L)));
            this.originalAuthzAsAcl = conf.getBoolean("sentry.authorization-provider.include-hdfs-authz-as-acl", false);
            LOG.info("Starting");
            LOG.info("Config: hdfs-user[{}] hdfs-group[{}] hdfs-permission[{}] include-hdfs-authz-as-acl[{}]", new Object[]{this.user, this.group, this.permission, this.originalAuthzAsAcl});
            if (this.authzInfo == null) {
                this.authzInfo = new SentryAuthorizationInfo(conf);
            }
            this.authzInfo.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
        LOG.debug(((Object)((Object)this)).getClass().getSimpleName() + ": Stopping");
        this.authzInfo.stop();
    }

    public INodeAttributes getAttributes(String[] pathElements, INodeAttributes inode) {
        Preconditions.checkNotNull((Object)pathElements);
        if (pathElements.length == 0) {
            return inode;
        }
        pathElements = "".equals(pathElements[0]) && pathElements.length > 1 ? Arrays.copyOfRange(pathElements, 1, pathElements.length) : pathElements;
        return this.isSentryManaged(pathElements) ? new SentryINodeAttributes(inode, pathElements) : inode;
    }

    public INodeAttributeProvider.AccessControlEnforcer getExternalAccessControlEnforcer(INodeAttributeProvider.AccessControlEnforcer defaultEnforcer) {
        return new SentryPermissionEnforcer(defaultEnforcer);
    }

    private static void addToACLMap(Map<String, AclEntry> map, Collection<AclEntry> entries) {
        for (AclEntry ent : entries) {
            String key = (ent.getName() == null ? "" : ent.getName()) + ent.getScope() + ent.getType();
            AclEntry aclEntry = map.get(key);
            if (aclEntry == null) {
                map.put(key, ent);
                continue;
            }
            map.put(key, new AclEntry.Builder().setName(ent.getName()).setScope(ent.getScope()).setType(ent.getType()).setPermission(ent.getPermission().or(aclEntry.getPermission())).build());
        }
    }

    private static List<AclEntry> createAclEntries(String user, String group, FsPermission permission) {
        ArrayList<AclEntry> list = new ArrayList<AclEntry>();
        AclEntry.Builder builder = new AclEntry.Builder();
        FsPermission fsPerm = new FsPermission(permission);
        builder.setName(user);
        builder.setType(AclEntryType.USER);
        builder.setScope(AclEntryScope.ACCESS);
        builder.setPermission(fsPerm.getUserAction());
        list.add(builder.build());
        builder.setName(group);
        builder.setType(AclEntryType.GROUP);
        builder.setScope(AclEntryScope.ACCESS);
        builder.setPermission(fsPerm.getGroupAction());
        list.add(builder.build());
        builder.setName(null);
        return list;
    }

    public class SentryINodeAttributes
    implements INodeAttributes {
        private final INodeAttributes defaultAttributes;
        private final String[] pathElements;

        public SentryINodeAttributes(INodeAttributes defaultAttributes, String[] pathElements) {
            this.defaultAttributes = defaultAttributes;
            this.pathElements = pathElements;
        }

        public boolean isDirectory() {
            return this.defaultAttributes.isDirectory();
        }

        public byte[] getLocalNameBytes() {
            return this.defaultAttributes.getLocalNameBytes();
        }

        public String getUserName() {
            return SentryINodeAttributesProvider.this.isSentryManaged(this.pathElements) ? SentryINodeAttributesProvider.this.user : this.defaultAttributes.getUserName();
        }

        public String getGroupName() {
            return SentryINodeAttributesProvider.this.isSentryManaged(this.pathElements) ? SentryINodeAttributesProvider.this.group : this.defaultAttributes.getGroupName();
        }

        public FsPermission getFsPermission() {
            FsPermission permission;
            if (!SentryINodeAttributesProvider.this.isSentryManaged(this.pathElements)) {
                permission = this.defaultAttributes.getFsPermission();
            } else {
                FsPermission returnPerm = SentryINodeAttributesProvider.this.permission;
                for (Object[] objectArray : SentryINodeAttributesProvider.this.authzInfo.getPathPrefixes()) {
                    if (!Arrays.equals(objectArray, this.pathElements)) continue;
                    returnPerm = FsPermission.createImmutable((short)((short)(returnPerm.toShort() | 1)));
                    break;
                }
                permission = returnPerm;
            }
            return permission;
        }

        public short getFsPermissionShort() {
            return this.getFsPermission().toShort();
        }

        public long getPermissionLong() {
            PermissionStatus permissionStatus = new PermissionStatus(this.getUserName(), this.getGroupName(), this.getFsPermission());
            return new INodeDirectory(0L, null, permissionStatus, 0L).getPermissionLong();
        }

        public AclFeature getAclFeature() {
            AclFeature aclFeature;
            String p = Arrays.toString(this.pathElements);
            boolean isPrefixed = false;
            boolean isStale = false;
            boolean hasAuthzObj = false;
            HashMap aclMap = null;
            if (!SentryINodeAttributesProvider.this.authzInfo.isUnderPrefix(this.pathElements)) {
                isPrefixed = false;
                aclFeature = this.defaultAttributes.getAclFeature();
            } else if (!SentryINodeAttributesProvider.this.authzInfo.doesBelongToAuthzObject(this.pathElements)) {
                isPrefixed = true;
                aclFeature = this.defaultAttributes.getAclFeature();
            } else {
                isPrefixed = true;
                hasAuthzObj = true;
                aclMap = new HashMap();
                if (SentryINodeAttributesProvider.this.originalAuthzAsAcl) {
                    String user = this.defaultAttributes.getUserName();
                    String group = this.defaultAttributes.getGroupName();
                    FsPermission perm = this.defaultAttributes.getFsPermission();
                    SentryINodeAttributesProvider.addToACLMap(aclMap, SentryINodeAttributesProvider.createAclEntries(user, group, perm));
                } else {
                    SentryINodeAttributesProvider.addToACLMap(aclMap, SentryINodeAttributesProvider.createAclEntries(SentryINodeAttributesProvider.this.user, SentryINodeAttributesProvider.this.group, SentryINodeAttributesProvider.this.permission));
                }
                if (!SentryINodeAttributesProvider.this.authzInfo.isStale()) {
                    isStale = false;
                    SentryINodeAttributesProvider.addToACLMap(aclMap, SentryINodeAttributesProvider.this.authzInfo.getAclEntries(this.pathElements));
                    aclFeature = new SentryAclFeature((ImmutableList<AclEntry>)ImmutableList.copyOf(aclMap.values()));
                } else {
                    isStale = true;
                    aclFeature = new SentryAclFeature((ImmutableList<AclEntry>)ImmutableList.copyOf(aclMap.values()));
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("### getAclEntry \n[" + (p == null ? "null" : p) + "] : [isPreifxed=" + isPrefixed + ", isStale=" + isStale + ", hasAuthzObj=" + hasAuthzObj + ", origAuthzAsAcl=" + SentryINodeAttributesProvider.this.originalAuthzAsAcl + "]\n[" + (aclMap == null ? "null" : aclMap) + "]\n");
            }
            return aclFeature;
        }

        public XAttrFeature getXAttrFeature() {
            return this.defaultAttributes.getXAttrFeature();
        }

        public long getModificationTime() {
            return this.defaultAttributes.getModificationTime();
        }

        public long getAccessTime() {
            return this.defaultAttributes.getAccessTime();
        }
    }

    class SentryPermissionEnforcer
    implements INodeAttributeProvider.AccessControlEnforcer {
        private final INodeAttributeProvider.AccessControlEnforcer ace;

        SentryPermissionEnforcer(INodeAttributeProvider.AccessControlEnforcer ace) {
            this.ace = ace;
        }

        public void checkPermission(String fsOwner, String supergroup, UserGroupInformation callerUgi, INodeAttributes[] inodeAttrs, INode[] inodes, byte[][] pathByNameArr, int snapshotId, String path, int ancestorIndex, boolean doCheckOwner, FsAction ancestorAccess, FsAction parentAccess, FsAction access, FsAction subAccess, boolean ignoreEmptyDir) throws AccessControlException {
            Object[] pathElems = this.getPathElems(pathByNameArr);
            if (pathElems != null && pathElems.length > 1 && "".equals(pathElems[0])) {
                pathElems = Arrays.copyOfRange(pathElems, 1, pathElems.length);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enforcing Permission : + " + Lists.newArrayList((Object[])new Serializable[]{fsOwner, supergroup, callerUgi.getShortUserName(), Arrays.toString(callerUgi.getGroupNames()), Arrays.toString(pathElems), ancestorAccess, parentAccess, access, subAccess, Boolean.valueOf(ignoreEmptyDir)}));
            }
            this.ace.checkPermission(fsOwner, supergroup, callerUgi, inodeAttrs, inodes, pathByNameArr, snapshotId, path, ancestorIndex, doCheckOwner, ancestorAccess, parentAccess, access, subAccess, ignoreEmptyDir);
        }

        private String[] getPathElems(byte[][] pathByName) {
            String[] retVal = new String[pathByName.length];
            for (int i = 0; i < pathByName.length; ++i) {
                retVal[i] = pathByName[i] != null ? DFSUtil.bytes2String((byte[])pathByName[i]) : "";
            }
            return retVal;
        }
    }

    static class SentryAclFeature
    extends AclFeature {
        public SentryAclFeature(ImmutableList<AclEntry> entries) {
            super(AclEntryStatusFormat.toInt(entries));
        }
    }
}

