/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.apache.sentry.api.service.thrift.SentryMetrics;
import org.apache.sentry.hdfs.PathDeltaRetriever;
import org.apache.sentry.hdfs.PathImageRetriever;
import org.apache.sentry.hdfs.PermDeltaRetriever;
import org.apache.sentry.hdfs.PermImageRetriever;
import org.apache.sentry.hdfs.SentryHDFSServiceProcessor;

final class SentryHdfsMetricsUtil {
    private static final SentryMetrics sentryMetrics = SentryMetrics.getInstance();
    static final Timer getAllAuthzUpdatesTimer = sentryMetrics.getTimer(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"get-all-authz-updates-from"}));
    static final Histogram getPermUpdateHistogram = sentryMetrics.getHistogram(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"perm-updates-size"}));
    static final Histogram getPathUpdateHistogram = sentryMetrics.getHistogram(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"paths-updates-size"}));
    public static final Timer getHandleHmsNotificationTimer = sentryMetrics.getTimer(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"handle-hms-notification"}));
    public static final Counter getFailedHandleHmsNotificationCounter = sentryMetrics.getCounter(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"handle-hms-notification", "failed-num"}));
    public static final Counter getHandleHmsHasFullImageCounter = sentryMetrics.getCounter(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"handle-hms-notification", "has-full-image-num"}));
    public static final Histogram getHandleHmsPathChangeHistogram = sentryMetrics.getHistogram(MetricRegistry.name(SentryHDFSServiceProcessor.class, (String[])new String[]{"handle-hms-notification", "path-changes-size"}));
    static final Timer getRetrievePermFullImageTimer = sentryMetrics.getTimer(MetricRegistry.name(PermImageRetriever.class, (String[])new String[]{"retrieve-perm-full-image"}));
    static final Histogram getPrivilegeChangesHistogram = sentryMetrics.getHistogram(MetricRegistry.name(PermImageRetriever.class, (String[])new String[]{"retrieve-perm-full-image", "privilege-changes-size"}));
    static final Histogram getRoleChangesHistogram = sentryMetrics.getHistogram(MetricRegistry.name(PermImageRetriever.class, (String[])new String[]{"retrieve-perm-full-image", "role-changes-size"}));
    static final Timer getRetrievePathFullImageTimer = sentryMetrics.getTimer(MetricRegistry.name(PathImageRetriever.class, (String[])new String[]{"retrieve-path-full-image"}));
    static final Histogram getPathChangesHistogram = sentryMetrics.getHistogram(MetricRegistry.name(PathImageRetriever.class, (String[])new String[]{"retrieve-path-full-image", "path-changes-size"}));
    static final Timer getDeltaPathChangesTimer = sentryMetrics.getTimer(MetricRegistry.name(PathDeltaRetriever.class, (String[])new String[]{"path", "delta", "time"}));
    static final Histogram getDeltaPathChangesHistogram = sentryMetrics.getHistogram(MetricRegistry.name(PathDeltaRetriever.class, (String[])new String[]{"path", "delta", "size"}));
    static final Timer getDeltaPermChangesTimer = sentryMetrics.getTimer(MetricRegistry.name(PermDeltaRetriever.class, (String[])new String[]{"perm", "delta", "time"}));
    static final Histogram getDeltaPermChangesHistogram = sentryMetrics.getHistogram(MetricRegistry.name(PermDeltaRetriever.class, (String[])new String[]{"perm", "delta", "size"}));

    private SentryHdfsMetricsUtil() {
    }
}

