/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.utils.ThriftUtil;
import org.apache.sentry.hdfs.SentryHDFSServiceProcessor;
import org.apache.sentry.hdfs.service.thrift.SentryHDFSService;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.apache.sentry.service.thrift.ProcessorFactory;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryHDFSServiceProcessorFactory
extends ProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHDFSServiceProcessorFactory.class);

    public SentryHDFSServiceProcessorFactory(Configuration conf) {
        super(conf);
    }

    public boolean register(TMultiplexedProcessor multiplexedProcessor, SentryStoreInterface _) throws Exception {
        SentryHDFSServiceProcessor sentryServiceHandler = new SentryHDFSServiceProcessor();
        LOGGER.info("Calling registerProcessor from SentryHDFSServiceProcessorFactory");
        ProcessorWrapper processor = new ProcessorWrapper(sentryServiceHandler);
        multiplexedProcessor.registerProcessor("SentryHDFSService", processor);
        return true;
    }

    static class ProcessorWrapper
    extends SentryHDFSService.Processor<SentryHDFSService.Iface> {
        public ProcessorWrapper(SentryHDFSService.Iface iface) {
            super(iface);
        }

        @Override
        public boolean process(TProtocol in, TProtocol out) throws TException {
            ThriftUtil.setIpAddress(in);
            ThriftUtil.setImpersonator(in);
            return super.process(in, out);
        }
    }
}

