/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.sentry.hdfs.ThriftSerializer;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPermissionsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TRoleChanges;
import org.apache.thrift.TException;

public class PermissionsUpdate
implements Updateable.Update {
    public static final String RENAME_PRIVS = "__RENAME_PRIV__";
    public static final String ALL_AUTHZ_OBJ = "__ALL_AUTHZ_OBJ__";
    public static final String ALL_PRIVS = "__ALL_PRIVS__";
    public static final String ALL_ROLES = "__ALL_ROLES__";
    public static final String ALL_GROUPS = "__ALL_GROUPS__";
    private final TPermissionsUpdate tPermUpdate;

    public PermissionsUpdate() {
        this(0L, false);
    }

    public PermissionsUpdate(TPermissionsUpdate tPermUpdate) {
        this.tPermUpdate = tPermUpdate;
    }

    public PermissionsUpdate(long seqNum, boolean hasFullImage) {
        this.tPermUpdate = new TPermissionsUpdate(hasFullImage, seqNum, new HashMap<String, TPrivilegeChanges>(), new HashMap<String, TRoleChanges>());
    }

    @Override
    public long getSeqNum() {
        return this.tPermUpdate.getSeqNum();
    }

    @Override
    public void setSeqNum(long seqNum) {
        this.tPermUpdate.setSeqNum(seqNum);
    }

    @Override
    public long getImgNum() {
        return -1L;
    }

    @Override
    public void setImgNum(long imgNum) {
        throw new UnsupportedOperationException("setImgNum not used");
    }

    @Override
    public boolean hasFullImage() {
        return this.tPermUpdate.isHasfullImage();
    }

    public TPrivilegeChanges addPrivilegeUpdate(String authzObj) {
        if (this.tPermUpdate.getPrivilegeChanges().containsKey(authzObj)) {
            return this.tPermUpdate.getPrivilegeChanges().get(authzObj);
        }
        TPrivilegeChanges privUpdate = new TPrivilegeChanges(authzObj, new HashMap<TPrivilegePrincipal, String>(), new HashMap<TPrivilegePrincipal, String>());
        this.tPermUpdate.getPrivilegeChanges().put(authzObj, privUpdate);
        return privUpdate;
    }

    public TRoleChanges addRoleUpdate(String role) {
        if (this.tPermUpdate.getRoleChanges().containsKey(role)) {
            return this.tPermUpdate.getRoleChanges().get(role);
        }
        TRoleChanges roleUpdate = new TRoleChanges(role, new ArrayList<String>(), new ArrayList<String>());
        this.tPermUpdate.getRoleChanges().put(role, roleUpdate);
        return roleUpdate;
    }

    Collection<TRoleChanges> getRoleUpdates() {
        return this.tPermUpdate.getRoleChanges().values();
    }

    Collection<TPrivilegeChanges> getPrivilegeUpdates() {
        return this.tPermUpdate.getPrivilegeChanges().values();
    }

    TPermissionsUpdate toThrift() {
        return this.tPermUpdate;
    }

    @Override
    public byte[] serialize() throws IOException {
        return ThriftSerializer.serialize(this.tPermUpdate);
    }

    @Override
    public void deserialize(byte[] data) throws IOException {
        ThriftSerializer.deserialize(this.tPermUpdate, data);
    }

    @Override
    public void JSONDeserialize(String update) throws TException {
        ThriftSerializer.deserializeFromJSON(this.tPermUpdate, update);
    }

    @Override
    public String JSONSerialize() throws TException {
        return ThriftSerializer.serializeToJSON(this.tPermUpdate);
    }

    public int hashCode() {
        return this.tPermUpdate == null ? 0 : this.tPermUpdate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PermissionsUpdate other = (PermissionsUpdate)obj;
        if (this.tPermUpdate == null) {
            return other.tPermUpdate == null;
        }
        return this.tPermUpdate.equals(other.tPermUpdate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.tPermUpdate + ")";
    }
}

