/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.codahale.metrics.Timer;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.hdfs.ImageRetriever;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.SentryHdfsMetricsUtil;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;

@ThreadSafe
class PathImageRetriever
implements ImageRetriever<PathsUpdate> {
    private final SentryStoreInterface sentryStore;
    private final String[] prefixes;

    PathImageRetriever(SentryStoreInterface sentryStore, String[] prefixes) {
        this.sentryStore = sentryStore;
        this.prefixes = prefixes;
    }

    @Override
    public PathsUpdate retrieveFullImage() throws Exception {
        try (Timer.Context timerContext = SentryHdfsMetricsUtil.getRetrievePathFullImageTimer.time();){
            PathsUpdate pathsUpdate = this.sentryStore.retrieveFullPathsImageUpdate(this.prefixes);
            return pathsUpdate;
        }
    }

    @Override
    public long getLatestImageID() throws Exception {
        return this.sentryStore.getLastProcessedImageID();
    }
}

