/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.sentry.hdfs.DeltaRetriever;
import org.apache.sentry.hdfs.ImageRetriever;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.service.thrift.SentryServiceState;
import org.apache.sentry.service.thrift.SentryState;
import org.apache.sentry.service.thrift.SentryStateBank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class DBUpdateForwarder<K extends Updateable.Update> {
    private final ImageRetriever<K> imageRetriever;
    private final DeltaRetriever<K> deltaRetriever;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBUpdateForwarder.class);
    private String retrieverType;

    DBUpdateForwarder(ImageRetriever<K> imageRetriever, DeltaRetriever<K> deltaRetriever) {
        this.imageRetriever = imageRetriever;
        this.deltaRetriever = deltaRetriever;
        this.retrieverType = imageRetriever.getClass().getName();
    }

    List<K> getAllUpdatesFrom(long seqNum, long imgNum) throws Exception {
        List<K> deltas;
        LOGGER.debug(String.format("(%s) GetAllUpdatesFrom sequence number %d, image number %d", this.retrieverType, seqNum, imgNum));
        if (imgNum >= 0L) {
            long curImgNum = this.imageRetriever.getLatestImageID();
            LOGGER.debug("({}) Current image number for is {}", (Object)this.retrieverType, (Object)curImgNum);
            if (curImgNum == 0L) {
                return Collections.emptyList();
            }
            if (curImgNum > imgNum) {
                List<K> fullImage = this.retrieveFullImage();
                if (!fullImage.isEmpty()) {
                    LOGGER.info("({}) A newer full update with image number {} was found and being sent to HDFS", (Object)this.retrieverType, (Object)curImgNum);
                }
                return fullImage;
            }
        }
        long curSeqNum = this.deltaRetriever.getLatestDeltaID();
        LOGGER.debug("({}) Current sequence number is {}", (Object)this.retrieverType, (Object)curSeqNum);
        if (seqNum == curSeqNum + 1L) {
            LOGGER.debug("{}, No new updates", (Object)this.retrieverType);
            return Collections.emptyList();
        }
        if (seqNum > 0L && this.deltaRetriever.isDeltaAvailable(seqNum) && !(deltas = this.deltaRetriever.retrieveDelta(seqNum, imgNum)).isEmpty()) {
            LOGGER.info("({}) Newer delta updates are found up to sequence number {} and being sent to HDFS", (Object)this.retrieverType, (Object)curSeqNum);
            return deltas;
        }
        List<K> fullImage = this.retrieveFullImage();
        if (fullImage != null && !fullImage.isEmpty()) {
            LOGGER.info("({}) A full update is returned due to an unavailable sequence number: {}", (Object)this.retrieverType, (Object)seqNum);
        }
        return fullImage;
    }

    private List<K> retrieveFullImage() throws Exception {
        if (SentryStateBank.isEnabled((String)"SentryService", (SentryState)SentryServiceState.FULL_UPDATE_RUNNING)) {
            LOGGER.debug("({}) A full update is being loaded. Delaying updating client with full image until its finished.", (Object)this.retrieverType);
            return Collections.emptyList();
        }
        return Collections.singletonList(this.imageRetriever.retrieveFullImage());
    }

    public static void translateOwnerPrivileges(Map<TPrivilegePrincipal, String> privMap) {
        if (privMap == null) {
            return;
        }
        for (Map.Entry<TPrivilegePrincipal, String> priv : privMap.entrySet()) {
            if (!priv.getValue().equalsIgnoreCase("OWNER")) continue;
            priv.setValue("*");
        }
    }
}

