/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.sentry.core.common.utils.PolicyFileConstants;
import org.apache.shiro.config.Ini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolicyFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyFiles.class);
    private static final String NL = System.getProperty("line.separator", "\n");

    public static void copyToDir(File dest, String ... resources) throws FileNotFoundException, IOException {
        for (String resource : resources) {
            LOGGER.debug("Copying " + resource + " to " + dest);
            try (OutputStream output = Files.newOutputStream(new File(dest, resource).toPath(), new OpenOption[0]);){
                Resources.copy((URL)Resources.getResource((String)resource), (OutputStream)output);
            }
        }
    }

    public static void copyToDir(FileSystem fs, Path dest, String ... resources) throws FileNotFoundException, IOException {
        for (String resource : resources) {
            InputStream in = Resources.getResource((String)resource).openStream();
            FSDataOutputStream out = fs.create(new Path(dest, resource));
            long bytes = ByteStreams.copy((InputStream)in, (OutputStream)out);
            in.close();
            out.hflush();
            out.close();
            LOGGER.debug("Copying " + resource + " to " + dest + ", bytes " + bytes);
        }
    }

    public static void copyFilesToDir(FileSystem fs, Path dest, File inputFile) throws IOException {
        try (InputStream input = Files.newInputStream(inputFile.toPath(), new OpenOption[0]);
             FSDataOutputStream out = fs.create(new Path(dest, inputFile.getName()));){
            ByteStreams.copy((InputStream)input, (OutputStream)out);
            out.hflush();
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ini loadFromPath(FileSystem fileSystem, Path path) throws IOException {
        InputStream inputStream = null;
        try {
            LOGGER.debug("Opening " + path);
            inputStream = fileSystem.open(path);
            Ini ini = new Ini();
            ini.load(inputStream);
            Ini ini2 = ini;
            return ini2;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error closing " + inputStream);
                }
            }
        }
    }

    public static void writeToPath(Ini iniFile, FileSystem fileSystem, Path path) throws IOException {
        if (fileSystem.exists(path)) {
            throw new IllegalArgumentException("The specified path " + path + " already exist!");
        }
        ArrayList<String> sectionStrs = new ArrayList<String>();
        for (String sectionName : PolicyFileConstants.SECTION_NAMES) {
            sectionStrs.add(PolicyFiles.toString(sectionName, iniFile.getSection(sectionName)));
        }
        String contents = Joiner.on((String)NL).join(sectionStrs.iterator());
        try (FSDataOutputStream out = fileSystem.create(path);){
            ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)fileSystem.getConf());
        }
    }

    private static String toString(String name, Ini.Section mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return "";
        }
        Joiner kvJoiner = Joiner.on((String)" = ");
        ArrayList lines = Lists.newArrayList();
        lines.add(NL);
        lines.add("[" + name + "]");
        for (String key : mapping.keySet()) {
            lines.add(kvJoiner.join((Object)key, (Object)mapping.get((Object)key), new Object[0]));
        }
        return Joiner.on((String)NL).join((Iterable)lines);
    }

    private PolicyFiles() {
    }
}

