/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.common.ImplyMethodType;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.policy.common.Privilege;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPrivilege
implements Privilege {
    private ImmutableList<KeyValue> parts;
    private boolean grantOption = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonPrivilege.class);

    public CommonPrivilege(String privilegeStr) {
        privilegeStr = Strings.nullToEmpty((String)privilegeStr).trim();
        if (privilegeStr.isEmpty()) {
            throw new IllegalArgumentException("Privilege string cannot be null or empty.");
        }
        LOGGER.debug("Create Privilege instance for privilegeStr={}", (Object)privilegeStr);
        ArrayList parts = Lists.newArrayList();
        for (String authorizable : SentryConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)privilegeStr)) {
            if (authorizable.isEmpty()) {
                throw new IllegalArgumentException("Privilege '" + privilegeStr + "' has an empty section");
            }
            parts.add(new KeyValue(authorizable));
        }
        if (parts.isEmpty()) {
            throw new AssertionError((Object)("Should never occur: " + privilegeStr));
        }
        KeyValue lastPart = (KeyValue)parts.get(parts.size() - 1);
        if (lastPart.getKey().equalsIgnoreCase("grantOption")) {
            this.grantOption = lastPart.getValue().equalsIgnoreCase("true");
            parts.remove(parts.size() - 1);
        }
        this.parts = ImmutableList.copyOf((Collection)parts);
    }

    @Override
    public boolean implies(Privilege privilege, Model model) {
        if (!(privilege instanceof CommonPrivilege)) {
            return false;
        }
        CommonPrivilege requiredPrivilege = (CommonPrivilege)privilege;
        if (requiredPrivilege.grantOption && !this.grantOption) {
            return false;
        }
        List<KeyValue> otherParts = requiredPrivilege.getParts();
        if (this.parts.equals(otherParts)) {
            return true;
        }
        int index = 0;
        for (KeyValue otherPart : otherParts) {
            if (this.parts.size() - 1 < index) {
                return true;
            }
            KeyValue part = (KeyValue)this.parts.get(index);
            String policyKey = part.getKey();
            if (!policyKey.equalsIgnoreCase(otherPart.getKey())) {
                if ("action".equalsIgnoreCase(policyKey)) continue;
                return false;
            }
            if ("action".equalsIgnoreCase(policyKey) ? !this.impliesAction(part.getValue(), otherPart.getValue(), model.getBitFieldActionFactory()) : !this.impliesResource((ImplyMethodType)model.getImplyMethodMap().get(policyKey.toLowerCase()), part.getValue(), otherPart.getValue())) {
                return false;
            }
            ++index;
        }
        while (index < this.parts.size()) {
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!this.isPrivilegeActionAll(part, model.getBitFieldActionFactory())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public List<KeyValue> getAuthorizable() {
        ArrayList<KeyValue> authorizable = new ArrayList<KeyValue>();
        for (KeyValue part : this.parts) {
            if ("action".equalsIgnoreCase(part.getKey())) continue;
            KeyValue keyValue = new KeyValue(part.getKey().toLowerCase(), part.getValue().toLowerCase());
            authorizable.add(keyValue);
        }
        return authorizable;
    }

    private boolean isPrivilegeActionAll(KeyValue actionPart, BitFieldActionFactory bitFieldActionFactory) {
        return this.impliesAction(actionPart.getValue(), "*", bitFieldActionFactory);
    }

    private boolean impliesResource(ImplyMethodType implyMethodType, String policyValue, String requestValue) {
        if ("*".equals(policyValue) || "*".equals(requestValue) || "ALL".equalsIgnoreCase(policyValue) || "ALL".equalsIgnoreCase(requestValue) || "+".equals(requestValue)) {
            return true;
        }
        if (ImplyMethodType.URL == implyMethodType) {
            return PathUtils.impliesURI((String)policyValue, (String)requestValue);
        }
        if (ImplyMethodType.STRING_CASE_SENSITIVE == implyMethodType) {
            return policyValue.equals(requestValue);
        }
        return policyValue.equalsIgnoreCase(requestValue);
    }

    private boolean impliesAction(String policyValue, String requestValue, BitFieldActionFactory bitFieldActionFactory) {
        BitFieldAction requestAction;
        BitFieldAction currentAction;
        try {
            currentAction = bitFieldActionFactory.getActionByName(policyValue);
            requestAction = bitFieldActionFactory.getActionByName(requestValue);
        }
        catch (SentryUserException e) {
            return false;
        }
        if (currentAction == null || requestAction == null) {
            return false;
        }
        return currentAction.implies(requestAction);
    }

    public String toString() {
        return SentryConstants.AUTHORIZABLE_JOINER.join(this.parts);
    }

    @Override
    public List<KeyValue> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (o instanceof CommonPrivilege) {
            CommonPrivilege cp = (CommonPrivilege)o;
            return this.parts.equals(cp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

