/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sentry.core.common.Action;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryConfigurationException;
import org.apache.sentry.core.common.exception.SentryGroupNotFoundException;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.GroupMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceAuthorizationProvider.class);
    private static final ThreadLocal<List<String>> lastFailedPrivileges = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private final GroupMappingService groupService;
    private final PolicyEngine policy;
    private final PrivilegeFactory privilegeFactory;
    private final Model model;

    public ResourceAuthorizationProvider(PolicyEngine policy, GroupMappingService groupService, Model model) {
        this.policy = policy;
        this.groupService = groupService;
        this.privilegeFactory = policy.getPrivilegeFactory();
        this.model = model;
    }

    @Override
    public boolean hasAccess(Subject subject, List<? extends Authorizable> authorizableHierarchy, Set<? extends Action> actions, ActiveRoleSet roleSet) {
        return this.hasAccess(subject, authorizableHierarchy, actions, false, roleSet);
    }

    @Override
    public boolean hasAccess(Subject subject, List<? extends Authorizable> authorizableHierarchy, Set<? extends Action> actions, boolean requireGrantOption, ActiveRoleSet roleSet) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authorization Request for " + subject + " " + authorizableHierarchy + " and " + actions);
        }
        Preconditions.checkNotNull((Object)subject, (Object)"Subject cannot be null");
        Preconditions.checkNotNull(authorizableHierarchy, (Object)"Authorizable cannot be null");
        Preconditions.checkArgument((!authorizableHierarchy.isEmpty() ? 1 : 0) != 0, (Object)"Authorizable cannot be empty");
        Preconditions.checkNotNull(actions, (Object)"Actions cannot be null");
        Preconditions.checkArgument((!actions.isEmpty() ? 1 : 0) != 0, (Object)"Actions cannot be empty");
        Preconditions.checkNotNull((Object)roleSet, (Object)"ActiveRoleSet cannot be null");
        boolean hasAccess = false;
        hasAccess = this.doHasAccess(subject, authorizableHierarchy, actions, requireGrantOption, roleSet);
        return hasAccess;
    }

    private boolean doHasAccess(Subject subject, List<? extends Authorizable> authorizables, Set<? extends Action> actions, boolean requireGrantOption, ActiveRoleSet roleSet) {
        Set<String> groups;
        try {
            groups = this.getGroups(subject);
        }
        catch (SentryGroupNotFoundException e) {
            groups = Collections.emptySet();
            LOGGER.debug("Groups not found for " + subject);
        }
        HashSet users = Sets.newHashSet((Object[])new String[]{subject.getName()});
        List<String> requestPrivileges = this.buildPermissions(authorizables, actions, requireGrantOption);
        LOGGER.debug("requestPrivileges={}", requestPrivileges);
        LOGGER.debug("PolicyEngine={}, PrivilegeFactory={}", (Object)this.policy.getClass().getName(), (Object)this.policy.getPrivilegeFactory().getClass().getName());
        LOGGER.debug("Get privileges for groups={}, users={}, roleSet={}", new Object[]{groups, users, roleSet});
        Iterable<Privilege> privileges = this.getPrivileges(groups, users, roleSet, authorizables.toArray(new Authorizable[0]));
        lastFailedPrivileges.get().clear();
        for (String requestPrivilege : requestPrivileges) {
            try {
                Privilege priv = this.privilegeFactory.createPrivilege(requestPrivilege);
                for (Privilege permission : privileges) {
                    boolean result = permission.implies(priv, this.model);
                    LOGGER.debug("ProviderPrivilege {}, RequestPrivilege {}, RoleSet {}, Result {}", new Object[]{permission, requestPrivilege, roleSet, result});
                    if (!result) continue;
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.error("doHasAccess: Exception", (Throwable)e);
                throw e;
            }
        }
        lastFailedPrivileges.get().addAll(requestPrivileges);
        return false;
    }

    private Iterable<Privilege> getPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable[] authorizables) {
        ImmutableSet privilegeObjects = this.policy.getPrivilegeObjects(groups, users, roleSet, authorizables);
        if (privilegeObjects != null && privilegeObjects.size() > 0) {
            return this.appendDefaultDBPrivObject((ImmutableSet<Privilege>)privilegeObjects, authorizables);
        }
        ImmutableSet privileges = this.policy.getPrivileges(groups, users, roleSet, authorizables);
        return Iterables.transform(this.appendDefaultDBPriv((ImmutableSet<String>)privileges, authorizables), (Function)new Function<String, Privilege>(){

            public Privilege apply(String privilege) {
                return ResourceAuthorizationProvider.this.privilegeFactory.createPrivilege(privilege);
            }
        });
    }

    private ImmutableSet<String> appendDefaultDBPriv(ImmutableSet<String> privileges, Authorizable[] authorizables) {
        if (authorizables != null && authorizables.length == 4 && authorizables[2].getName().equals("+") && privileges.size() == 1 && this.hasOnlyServerPrivilege((String)privileges.asList().get(0))) {
            String defaultPriv = "Server=" + authorizables[0].getName() + "->Db=default->Table=*->Column=*->action=select";
            HashSet newPrivs = Sets.newHashSet((Object[])new String[]{defaultPriv});
            return ImmutableSet.copyOf((Collection)newPrivs);
        }
        return privileges;
    }

    private boolean hasOnlyServerPrivilege(String priv) {
        ArrayList l = Lists.newArrayList((Iterable)SentryConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)priv));
        if (l.size() == 1 && ((String)l.get(0)).toLowerCase().startsWith("server")) {
            return ((String)l.get(0)).toLowerCase().split("=")[1].endsWith("+");
        }
        return false;
    }

    private ImmutableSet<Privilege> appendDefaultDBPrivObject(ImmutableSet<Privilege> privileges, Authorizable[] authorizables) {
        if (authorizables != null && authorizables.length == 4 && authorizables[2].getName().equals("+") && privileges.size() == 1 && this.hasOnlyServerPrivilege((Privilege)privileges.asList().get(0))) {
            String defaultPrivString = "Server=" + authorizables[0].getName() + "->Db=default->Table=*->Column=*->action=select";
            Privilege defaultPriv = this.privilegeFactory.createPrivilege(defaultPrivString);
            return ImmutableSet.of((Object)defaultPriv);
        }
        return privileges;
    }

    private boolean hasOnlyServerPrivilege(Privilege privObj) {
        if (privObj.getParts().size() == 1 && ((KeyValue)privObj.getParts().get(0)).getKey().equalsIgnoreCase("server")) {
            return ((KeyValue)privObj.getParts().get(0)).getValue().endsWith("+");
        }
        return false;
    }

    @Override
    public GroupMappingService getGroupMapping() {
        return this.groupService;
    }

    private Set<String> getGroups(Subject subject) throws SentryGroupNotFoundException {
        return this.groupService.getGroups(subject.getName());
    }

    @Override
    public void validateResource(boolean strictValidation) throws SentryConfigurationException {
        this.policy.validatePolicy(strictValidation);
    }

    @Override
    public Set<String> listPrivilegesForSubject(Subject subject) throws SentryConfigurationException, SentryGroupNotFoundException {
        return this.policy.getPrivileges(this.getGroups(subject), (Set)Sets.newHashSet((Object[])new String[]{subject.getName()}), ActiveRoleSet.ALL, (Authorizable[])null);
    }

    @Override
    public Set<String> listPrivilegesForGroup(String groupName) throws SentryConfigurationException {
        return this.policy.getPrivileges((Set)Sets.newHashSet((Object[])new String[]{groupName}), ActiveRoleSet.ALL, new Authorizable[0]);
    }

    @Override
    public List<String> getLastFailedPrivileges() {
        return lastFailedPrivileges.get();
    }

    @Override
    public void close() {
        if (this.policy != null) {
            this.policy.close();
        }
    }

    private List<String> buildPermissions(List<? extends Authorizable> authorizables, Set<? extends Action> actions, boolean requireGrantOption) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        ArrayList<String> requestedPermissions = new ArrayList<String>();
        for (Authorizable authorizable : authorizables) {
            hierarchy.add(SentryConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
        }
        for (Action action : actions) {
            String requestPermission = SentryConstants.AUTHORIZABLE_JOINER.join(hierarchy);
            requestPermission = SentryConstants.AUTHORIZABLE_JOINER.join((Object)requestPermission, (Object)SentryConstants.KV_JOINER.join((Object)"action", (Object)action.getValue(), new Object[0]), new Object[0]);
            requestPermission = SentryConstants.AUTHORIZABLE_JOINER.join((Object)requestPermission, (Object)SentryConstants.KV_JOINER.join((Object)"grantOption", (Object)requireGrantOption, new Object[0]), new Object[0]);
            requestedPermissions.add(requestPermission);
        }
        return requestedPermissions;
    }

    @Override
    public PolicyEngine getPolicyEngine() {
        return this.policy;
    }
}

