/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.sentry.core.common.exception.SentryGroupNotFoundException;
import org.apache.sentry.provider.common.GroupMappingService;

public class HadoopGroupMappingService
implements GroupMappingService {
    private static Configuration hadoopConf;
    private final Groups groups;

    public HadoopGroupMappingService(Groups groups) {
        this.groups = groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HadoopGroupMappingService(Configuration conf, String resource) {
        if (hadoopConf == null) {
            Class<HadoopGroupMappingService> clazz = HadoopGroupMappingService.class;
            // MONITORENTER : org.apache.sentry.provider.common.HadoopGroupMappingService.class
            if (hadoopConf == null) {
                hadoopConf = new Configuration();
                hadoopConf.addResource(conf);
                if (!StringUtils.isEmpty((String)resource)) {
                    hadoopConf.addResource(resource);
                }
            }
            // MONITOREXIT : clazz
        }
        this.groups = Groups.getUserToGroupsMappingService((Configuration)hadoopConf);
    }

    @Override
    public Set<String> getGroups(String user) throws SentryGroupNotFoundException {
        List groupList = Lists.newArrayList();
        try {
            groupList = this.groups.getGroups(user);
        }
        catch (IOException e) {
            throw new SentryGroupNotFoundException("Unable to obtain groups for " + user, (Throwable)e);
        }
        if (groupList == null || groupList.isEmpty()) {
            throw new SentryGroupNotFoundException("Unable to obtain groups for " + user);
        }
        return new HashSet<String>(groupList);
    }
}

