/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapTokenLocalClient {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTokenLocalClient.class);
    private final SecretManager secretManager;

    public LlapTokenLocalClient(Configuration conf, String clusterId) {
        this.secretManager = SecretManager.createSecretManager((Configuration)conf, (String)clusterId);
    }

    public Token<LlapTokenIdentifier> createToken(String appId, String user, boolean isSignatureRequired) throws IOException {
        try {
            Token token = this.secretManager.createLlapToken(appId, user, isSignatureRequired);
            if (LOG.isInfoEnabled()) {
                LOG.info("Created a LLAP delegation token locally: " + token);
            }
            return token;
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
    }

    public void close() {
        try {
            this.secretManager.stopThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

