/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.solr.conf;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAuthzConf
extends Configuration {
    private static final Map<String, AuthzConfVars> currentToDeprecatedProps = new HashMap<String, AuthzConfVars>();
    private static final Logger LOG;
    public static final String AUTHZ_SITE_FILE = "sentry-site.xml";

    public SolrAuthzConf(List<URL> sentryConf) {
        super(true);
        for (URL u : sentryConf) {
            this.addResource(u, true);
        }
    }

    public String get(String varName) {
        String retVal = super.get(varName);
        if (retVal == null) {
            if (currentToDeprecatedProps.containsKey(varName)) {
                AuthzConfVars var = currentToDeprecatedProps.get(varName);
                retVal = super.get(var.getVar());
            }
            if (retVal == null) {
                retVal = AuthzConfVars.getDefault(varName);
            } else {
                LOG.warn("Using the deprecated config setting " + currentToDeprecatedProps.get(varName).getVar() + " instead of " + varName);
            }
        }
        return retVal;
    }

    static {
        currentToDeprecatedProps.put(AuthzConfVars.AUTHZ_PROVIDER.getVar(), AuthzConfVars.AUTHZ_PROVIDER_DEPRECATED);
        LOG = LoggerFactory.getLogger(SolrAuthzConf.class);
    }

    public static enum AuthzConfVars {
        AUTHZ_PROVIDER("sentry.solr.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider"),
        AUTHZ_PROVIDER_RESOURCE("sentry.solr.provider.resource", ""),
        AUTHZ_PROVIDER_BACKEND("sentry.solr.provider.backend", "org.apache.sentry.provider.file.SimpleFileProviderBackend"),
        AUTHZ_POLICY_ENGINE("sentry.solr.policy.engine", "org.apache.sentry.policy.engine.common.CommonPolicyEngine"),
        AUTHZ_PROVIDER_DEPRECATED("sentry.provider", "org.apache.sentry.provider.common.HadoopGroupResourceAuthorizationProvider");

        private final String varName;
        private final String defaultVal;

        private AuthzConfVars(String varName, String defaultVal) {
            this.varName = varName;
            this.defaultVal = defaultVal;
        }

        public String getVar() {
            return this.varName;
        }

        public String getDefault() {
            return this.defaultVal;
        }

        public static String getDefault(String varName) {
            for (AuthzConfVars oneVar : AuthzConfVars.values()) {
                if (!oneVar.getVar().equalsIgnoreCase(varName)) continue;
                return oneVar.getDefault();
            }
            return null;
        }
    }
}

