/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hbaseindexer.authz;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.binding.hbaseindexer.conf.HBaseIndexerAuthzConf;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.model.indexer.Indexer;
import org.apache.sentry.core.model.indexer.IndexerModelAction;
import org.apache.sentry.core.model.indexer.IndexerPrivilegeModel;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseIndexerAuthzBinding {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseIndexerAuthzBinding.class);
    private static final String[] HADOOP_HBASE_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml", "hadoop-site.xml", "hbase-site.xml"};
    public static final String HBASE_REGIONSERVER_KEYTAB_FILE = "hbase.regionserver.keytab.file";
    public static final String HBASE_REGIONSERVER_KERBEROS_PRINCIPAL = "hbase.regionserver.kerberos.principal";
    private static final AtomicBoolean kerberosInit = new AtomicBoolean(false);
    private final HBaseIndexerAuthzConf authzConf;
    private final AuthorizationProvider authProvider;
    private ProviderBackend providerBackend;

    public HBaseIndexerAuthzBinding(HBaseIndexerAuthzConf authzConf) throws Exception {
        this.authzConf = this.addHdfsPropsToConf(authzConf);
        this.authProvider = this.getAuthProvider();
    }

    private AuthorizationProvider getAuthProvider() throws Exception {
        String authProviderName = this.authzConf.get(HBaseIndexerAuthzConf.AuthzConfVars.AUTHZ_PROVIDER.getVar());
        String resourceName = this.authzConf.get(HBaseIndexerAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar());
        String providerBackendName = this.authzConf.get(HBaseIndexerAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar());
        String policyEngineName = this.authzConf.get(HBaseIndexerAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar());
        LOG.debug("Using HBase indexer authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        if ("kerberos".equals(this.authzConf.get("hadoop.security.authentication"))) {
            String keytabProp = this.authzConf.get(HBASE_REGIONSERVER_KEYTAB_FILE);
            String principalProp = this.authzConf.get(HBASE_REGIONSERVER_KERBEROS_PRINCIPAL);
            if (keytabProp != null && principalProp != null) {
                String actualHost = this.authzConf.get(HBaseIndexerAuthzConf.AuthzConfVars.PRINCIPAL_HOSTNAME.getVar());
                if (actualHost != null) {
                    principalProp = SecurityUtil.getServerPrincipal((String)principalProp, (String)actualHost);
                }
                this.initKerberos(keytabProp, principalProp);
            }
        }
        this.authzConf.set("sentry.provider.backend.generic.component-type", "hbaseindexer");
        this.providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(new Object[]{this.authzConf, resourceName});
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(true);
        context.setValidators(IndexerPrivilegeModel.getInstance().getPrivilegeValidators());
        this.providerBackend.initialize(context);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(this.providerBackend);
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(String.class, PolicyEngine.class, Model.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(resourceName, policyEngine, IndexerPrivilegeModel.getInstance());
    }

    public void authorize(Subject subject, Indexer indexer, Set<IndexerModelAction> actions) throws SentryAccessDeniedException {
        if (!this.authProvider.hasAccess(subject, Arrays.asList(indexer), actions, ActiveRoleSet.ALL)) {
            throw new SentryAccessDeniedException(String.format("User '%s' does not have privileges for indexer '%s'", subject != null ? subject.getName() : "", indexer != null ? indexer.getName() : ""));
        }
    }

    public Collection<Indexer> filterIndexers(Subject subject, Collection<Indexer> indexers) {
        ArrayList<Indexer> filteredIndexers = new ArrayList<Indexer>();
        EnumSet<IndexerModelAction> actions = EnumSet.of(IndexerModelAction.READ);
        for (Indexer def : indexers) {
            if (!this.authProvider.hasAccess(subject, Arrays.asList(new Indexer(def.getName())), actions, ActiveRoleSet.ALL)) continue;
            filteredIndexers.add(def);
        }
        return filteredIndexers;
    }

    private HBaseIndexerAuthzConf addHdfsPropsToConf(HBaseIndexerAuthzConf conf) throws IOException {
        String hdfsConfdirKey = "hbaseindxer.hdfs.confdir";
        String confDir = System.getProperty("hbaseindxer.hdfs.confdir", ".");
        if (confDir != null && confDir.length() > 0) {
            File confDirFile = new File(confDir);
            if (!confDirFile.exists()) {
                throw new IOException(String.format("The HBase indexer resource '%s' does not exist. Use the '%s' configuration variable to specify an existing resource directory.", confDirFile.getAbsolutePath(), "hbaseindxer.hdfs.confdir"));
            }
            if (!confDirFile.isDirectory()) {
                throw new IOException(String.format("The HBase indexer resource '%s' is not a directory. Use the '%s' configuration variable to specify an existing resource directory.", confDirFile.getAbsolutePath(), "hbaseindxer.hdfs.confdir"));
            }
            if (!confDirFile.canRead()) {
                throw new IOException(String.format("The HBase indexer resource '%s' does not have read permissions. Change the directory\npermissions to allow the HBase indexer process to read or use the %s' configuration variable to specify an existing resource directory with read permissions.", confDirFile.getAbsolutePath(), "hbaseindxer.hdfs.confdir"));
            }
            for (String file : HADOOP_HBASE_CONF_FILES) {
                if (!new File(confDirFile, file).exists()) continue;
                conf.addResource(new Path(confDir, file), true);
            }
        }
        return conf;
    }

    private void initKerberos(String keytabFile, String principal) {
        if (keytabFile == null || keytabFile.length() == 0) {
            throw new IllegalArgumentException(String.format("Setting keytab file path required when kerberos is enabled. Use %s configuration entry to define keytab file.", HBASE_REGIONSERVER_KEYTAB_FILE));
        }
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException(String.format("Setting kerberos principal is required when kerberos is enabled. Use %s configuration entry to define principal.", HBASE_REGIONSERVER_KERBEROS_PRINCIPAL));
        }
        if (kerberosInit.compareAndSet(false, true)) {
            Configuration ugiConf = new Configuration((Configuration)this.authzConf);
            UserGroupInformation.setConfiguration((Configuration)ugiConf);
            LOG.info("Attempting to acquire kerberos ticket for HBase Indexer binding with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
            }
            catch (IOException ioe) {
                kerberosInit.set(false);
                throw new RuntimeException(ioe);
            }
            LOG.info("Got Kerberos ticket for HBase Indexer binding");
        }
    }
}

