/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.http;

import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapStatusOptionsProcessor;
import org.apache.hadoop.hive.llap.cli.LlapStatusServiceDriver;
import org.apache.hive.http.HttpServer;
import org.apache.hive.http.JMXJsonServlet;

public class LlapServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(JMXJsonServlet.class);
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";

    public void init() throws ServletException {
    }

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hive.conf");
        assert (conf != null);
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!HttpServer.isInstrumentationAccessAllowed((ServletContext)this.getServletContext(), (HttpServletRequest)request, (HttpServletResponse)response)) {
                return;
            }
            String clusterName = HiveConf.getVar((Configuration)this.getConfFromContext(), (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
            try (PrintWriter writer = null;){
                response.setContentType("application/json; charset=utf8");
                response.setHeader(ACCESS_CONTROL_ALLOW_METHODS, "GET");
                response.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN, "*");
                response.setHeader("Cache-Control", "no-transform,public,max-age=60,s-maxage=60");
                writer = response.getWriter();
                if (clusterName != null) {
                    clusterName = clusterName.trim();
                }
                if (clusterName == null || clusterName.isEmpty()) {
                    writer.print("{\"LLAP\": \"No llap daemons configured. ");
                    writer.print("Check hive.llap.daemon.service.hosts.\"}");
                    return;
                }
                if (clusterName.startsWith("@")) {
                    clusterName = clusterName.substring(1);
                }
                LOG.info((Object)("Retrieving info for cluster: " + clusterName));
                LlapStatusServiceDriver driver = new LlapStatusServiceDriver();
                int ret = driver.run(new LlapStatusOptionsProcessor.LlapStatusOptions(clusterName));
                if (ret == LlapStatusServiceDriver.ExitCode.SUCCESS.getInt()) {
                    driver.outputJson(writer);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Caught exception while processing llap status request", (Throwable)e);
            response.setStatus(500);
        }
    }
}

