/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.hdfs.SentryAuthorizationInfo;
import org.apache.sentry.hdfs.SentryAuthzUpdate;
import org.apache.sentry.hdfs.SentryHDFSServiceClient;
import org.apache.sentry.hdfs.SentryHDFSServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SentryUpdater {
    private SentryHDFSServiceClient sentryClient;
    private final Configuration conf;
    private final SentryAuthorizationInfo authzInfo;
    private static final Logger LOG = LoggerFactory.getLogger(SentryUpdater.class);

    SentryUpdater(Configuration conf, SentryAuthorizationInfo authzInfo) throws Exception {
        this.conf = conf;
        this.authzInfo = authzInfo;
    }

    SentryAuthzUpdate getUpdates() {
        if (this.sentryClient == null) {
            try {
                this.sentryClient = SentryHDFSServiceClientFactory.create((Configuration)this.conf);
            }
            catch (Exception e) {
                LOG.error("Error connecting to Sentry !!", (Object)e.getMessage());
                this.sentryClient = null;
                return null;
            }
        }
        try {
            return this.sentryClient.getAllUpdatesFrom(this.authzInfo.getAuthzPermissions().getLastUpdatedSeqNum() + 1L, this.authzInfo.getAuthzPaths().getLastUpdatedSeqNum() + 1L, this.authzInfo.getAuthzPaths().getLastUpdatedImgNum());
        }
        catch (Exception e) {
            this.sentryClient = null;
            LOG.error("Error receiving updates from Sentry", (Throwable)e);
            return null;
        }
    }
}

