/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.sentry.hdfs.AuthzPermissions;
import org.apache.sentry.hdfs.SentryINodeAttributesProvider;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryPermissions
implements AuthzPermissions {
    private final Map<String, PrivilegeInfo> privileges = new TreeMap<String, PrivilegeInfo>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Set<String>> authzObjChildren = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, RoleInfo> roles = new TreeMap<String, RoleInfo>(String.CASE_INSENSITIVE_ORDER);
    private static Logger LOG = LoggerFactory.getLogger(SentryINodeAttributesProvider.class);

    String getParentAuthzObject(String authzObject) {
        int dot;
        if (authzObject != null && (dot = authzObject.indexOf(46)) > 0) {
            return authzObject.substring(0, dot);
        }
        return authzObject;
    }

    void addParentChildMappings(String authzObject) {
        String parent = this.getParentAuthzObject(authzObject);
        if (parent != null) {
            Set<String> children = this.authzObjChildren.get(parent);
            if (children == null) {
                children = new HashSet<String>();
                this.authzObjChildren.put(parent, children);
            }
            children.add(authzObject);
        }
    }

    void removeParentChildMappings(String authzObject) {
        String parent = this.getParentAuthzObject(authzObject);
        if (parent != null) {
            Set<String> children = this.authzObjChildren.get(parent);
            if (children != null) {
                children.remove(authzObject);
            }
        } else {
            this.authzObjChildren.remove(authzObject);
        }
    }

    private Map<HdfsAclEntity, FsAction> getPerms(String authzObj) {
        String parent = this.getParentAuthzObject(authzObj);
        Map<Object, Object> perms = parent == null || parent.equals(authzObj) ? new HashMap() : this.getPerms(parent);
        PrivilegeInfo privilegeInfo = this.privileges.get(authzObj);
        if (privilegeInfo != null) {
            for (Map.Entry<TPrivilegePrincipal, FsAction> privs : privilegeInfo.getAllPermissions().entrySet()) {
                this.constructHdfsPermissions(privs.getKey(), privs.getValue(), perms);
            }
        }
        return perms;
    }

    public List<AclEntry> getAcls(String authzObj) {
        Map<HdfsAclEntity, FsAction> permissions = this.getPerms(authzObj);
        LinkedList<AclEntry> retList = new LinkedList<AclEntry>();
        for (Map.Entry<HdfsAclEntity, FsAction> permission : permissions.entrySet()) {
            AclEntry.Builder builder = new AclEntry.Builder();
            if (permission.getKey().getType() == AclEntryType.GROUP) {
                builder.setName(permission.getKey().getValue());
                builder.setType(AclEntryType.GROUP);
            } else if (permission.getKey().getType() == AclEntryType.USER) {
                builder.setName(permission.getKey().getValue());
                builder.setType(AclEntryType.USER);
            } else {
                LOG.warn("Permissions for Invalid AclEntryType: %s", (Object)permission.getKey().getType());
                continue;
            }
            builder.setScope(AclEntryScope.ACCESS);
            FsAction action = permission.getValue();
            if (action == FsAction.READ || action == FsAction.WRITE || action == FsAction.READ_WRITE) {
                action = action.or(FsAction.EXECUTE);
            }
            builder.setPermission(action);
            retList.add(builder.build());
        }
        return retList;
    }

    private void constructHdfsPermissions(TPrivilegePrincipal privilegePrincipal, FsAction permission, Map<HdfsAclEntity, FsAction> perms) {
        if (privilegePrincipal.getType() == TPrivilegePrincipalType.ROLE) {
            RoleInfo roleInfo = this.roles.get(privilegePrincipal.getValue());
            if (roleInfo != null) {
                for (String group : roleInfo.groups) {
                    HdfsAclEntity aclEntry = HdfsAclEntity.constructAclEntityForGroup(group);
                    FsAction fsAction = perms.get(aclEntry);
                    if (fsAction == null) {
                        fsAction = FsAction.NONE;
                    }
                    perms.put(aclEntry, fsAction.or(permission));
                }
            }
        } else if (privilegePrincipal.getType() == TPrivilegePrincipalType.USER) {
            HdfsAclEntity aclEntry = HdfsAclEntity.constructAclEntityForUser(privilegePrincipal.getValue());
            FsAction fsAction = perms.get(aclEntry);
            if (fsAction == null) {
                fsAction = FsAction.NONE;
            }
            perms.put(aclEntry, fsAction.or(permission));
        }
    }

    public PrivilegeInfo getPrivilegeInfo(String authzObj) {
        return this.privileges.get(authzObj);
    }

    Collection<PrivilegeInfo> getAllPrivileges() {
        return this.privileges.values();
    }

    Collection<RoleInfo> getAllRoles() {
        return this.roles.values();
    }

    public void delPrivilegeInfo(String authzObj) {
        this.privileges.remove(authzObj);
    }

    public void addPrivilegeInfo(PrivilegeInfo privilegeInfo) {
        this.privileges.put(privilegeInfo.authzObj, privilegeInfo);
    }

    public Set<String> getChildren(String authzObj) {
        return this.authzObjChildren.get(authzObj);
    }

    public RoleInfo getRoleInfo(String role) {
        return this.roles.get(role);
    }

    public void delRoleInfo(String role) {
        this.roles.remove(role);
    }

    public void addRoleInfo(RoleInfo roleInfo) {
        this.roles.put(roleInfo.role, roleInfo);
    }

    public String dumpContent() {
        return new StringBuffer(this.getClass().getSimpleName()).append(": Privileges: ").append(this.privileges).append(", Roles: ").append(this.roles).append(", AuthzObjChildren: ").append(this.authzObjChildren).toString();
    }

    public String toString() {
        return new StringBuffer(this.getClass().getSimpleName()).append(": Privileges: ").append(this.privileges.size()).append(", Roles: ").append(this.roles.size()).append(", AuthzObjChildren: ").append(this.authzObjChildren.size()).toString();
    }

    public static class HdfsAclEntity {
        private final AclEntryType type;
        private final String value;

        private HdfsAclEntity(AclEntryType type, String value) throws IllegalArgumentException {
            if (type != AclEntryType.USER && type != AclEntryType.GROUP) {
                throw new IllegalArgumentException("Invalid AclEntryType");
            }
            this.type = type;
            this.value = value;
        }

        public static HdfsAclEntity constructAclEntityForUser(String user) {
            return new HdfsAclEntity(AclEntryType.USER, user);
        }

        public static HdfsAclEntity constructAclEntityForGroup(String group) {
            return new HdfsAclEntity(AclEntryType.GROUP, group);
        }

        public AclEntryType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HdfsAclEntity other = (HdfsAclEntity)obj;
            if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }
    }

    public static class RoleInfo {
        private final String role;
        private final Set<String> groups = new HashSet<String>();

        public RoleInfo(String role) {
            this.role = role;
        }

        public RoleInfo addGroup(String group) {
            this.groups.add(group);
            return this;
        }

        public RoleInfo delGroup(String group) {
            this.groups.remove(group);
            return this;
        }

        public String getRole() {
            return this.role;
        }

        public Set<String> getAllGroups() {
            return this.groups;
        }

        public String toString() {
            return "RoleInfo(" + this.role + " --> " + this.groups + ")";
        }
    }

    public static class PrivilegeInfo {
        private final String authzObj;
        private final Map<TPrivilegePrincipal, FsAction> privilegeEntityFsActionMap = new HashMap<TPrivilegePrincipal, FsAction>();

        public PrivilegeInfo(String authzObj) {
            this.authzObj = authzObj;
        }

        public PrivilegeInfo setPermission(TPrivilegePrincipal privilegeEntity, FsAction perm) {
            this.privilegeEntityFsActionMap.put(privilegeEntity, perm);
            return this;
        }

        public PrivilegeInfo removePermission(TPrivilegePrincipal privilegeEntity) {
            this.privilegeEntityFsActionMap.remove(privilegeEntity);
            return this;
        }

        public FsAction getPermission(TPrivilegePrincipal privilegeEntity) {
            return this.privilegeEntityFsActionMap.get(privilegeEntity);
        }

        public Map<TPrivilegePrincipal, FsAction> getAllPermissions() {
            return this.privilegeEntityFsActionMap;
        }

        public String getAuthzObj() {
            return this.authzObj;
        }

        public String toString() {
            return "PrivilegeInfo(" + this.authzObj + " --> " + this.privilegeEntityFsActionMap + ")";
        }
    }
}

