/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.EnumSet;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptionSwitch;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.RetriableDirectoryCreateCommand;
import org.apache.hadoop.tools.mapred.RetriableFileCopyCommand;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMapper
extends Mapper<Text, CopyListingFileStatus, Text, Text> {
    private static Logger LOG = LoggerFactory.getLogger(CopyMapper.class);
    private Configuration conf;
    private boolean syncFolders = false;
    private boolean ignoreFailures = false;
    private boolean skipCrc = false;
    private boolean overWrite = false;
    private boolean append = false;
    private boolean verboseLog = false;
    private boolean directWrite = false;
    private EnumSet<DistCpOptions.FileAttribute> preserve = EnumSet.noneOf(DistCpOptions.FileAttribute.class);
    private FileSystem targetFS = null;
    private Path targetWorkPath = null;
    private long startEpoch;
    private long totalBytesCopied = 0L;

    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        this.conf = context.getConfiguration();
        this.syncFolders = this.conf.getBoolean(DistCpOptionSwitch.SYNC_FOLDERS.getConfigLabel(), false);
        this.ignoreFailures = this.conf.getBoolean(DistCpOptionSwitch.IGNORE_FAILURES.getConfigLabel(), false);
        this.skipCrc = this.conf.getBoolean(DistCpOptionSwitch.SKIP_CRC.getConfigLabel(), false);
        this.overWrite = this.conf.getBoolean(DistCpOptionSwitch.OVERWRITE.getConfigLabel(), false);
        this.append = this.conf.getBoolean(DistCpOptionSwitch.APPEND.getConfigLabel(), false);
        this.verboseLog = this.conf.getBoolean(DistCpOptionSwitch.VERBOSE_LOG.getConfigLabel(), false);
        this.preserve = DistCpUtils.unpackAttributes(this.conf.get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel()));
        this.directWrite = this.conf.getBoolean(DistCpOptionSwitch.DIRECT_WRITE.getConfigLabel(), false);
        this.targetWorkPath = new Path(this.conf.get("distcp.target.work.path"));
        Path targetFinalPath = new Path(this.conf.get("distcp.target.final.path"));
        this.targetFS = targetFinalPath.getFileSystem(this.conf);
        try {
            this.overWrite = this.overWrite || this.targetFS.getFileStatus(targetFinalPath).isFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.startEpoch = System.currentTimeMillis();
    }

    public void map(Text relPath, CopyListingFileStatus sourceFileStatus, Mapper.Context context) throws IOException, InterruptedException {
        Path sourcePath = sourceFileStatus.getPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("DistCpMapper::map(): Received " + sourcePath + ", " + relPath);
        }
        Path target = new Path(this.targetWorkPath.makeQualified(this.targetFS.getUri(), this.targetFS.getWorkingDirectory()) + relPath.toString());
        EnumSet<DistCpOptions.FileAttribute> fileAttributes = CopyMapper.getFileAttributeSettings(context);
        boolean preserveRawXattrs = context.getConfiguration().getBoolean("distcp.preserve.rawxattrs", false);
        String description = "Copying " + sourcePath + " to " + target;
        context.setStatus(description);
        LOG.info(description);
        try {
            FileStatus targetStatus;
            CopyListingFileStatus sourceCurrStatus;
            FileSystem sourceFS;
            block14: {
                try {
                    sourceFS = sourcePath.getFileSystem(this.conf);
                    boolean preserveXAttrs = fileAttributes.contains((Object)DistCpOptions.FileAttribute.XATTR);
                    sourceCurrStatus = DistCpUtils.toCopyListingFileStatusHelper(sourceFS, sourceFS.getFileStatus(sourcePath), fileAttributes.contains((Object)DistCpOptions.FileAttribute.ACL), preserveXAttrs, preserveRawXattrs, sourceFileStatus.getChunkOffset(), sourceFileStatus.getChunkLength());
                }
                catch (FileNotFoundException e) {
                    throw new IOException(new RetriableFileCopyCommand.CopyReadException(e));
                }
                targetStatus = null;
                try {
                    targetStatus = this.targetFS.getFileStatus(target);
                }
                catch (FileNotFoundException ignore) {
                    if (!LOG.isDebugEnabled()) break block14;
                    LOG.debug("Path could not be found: " + target, (Throwable)ignore);
                }
            }
            if (targetStatus != null && targetStatus.isDirectory() != sourceCurrStatus.isDirectory()) {
                throw new IOException("Can't replace " + target + ". Target is " + this.getFileType(targetStatus) + ", Source is " + this.getFileType(sourceCurrStatus));
            }
            if (sourceCurrStatus.isDirectory()) {
                this.createTargetDirsWithRetry(description, target, context);
                return;
            }
            FileAction action = this.checkUpdate(sourceFS, sourceCurrStatus, target, targetStatus);
            Path tmpTarget = target;
            if (action == FileAction.SKIP) {
                LOG.info("Skipping copy of " + sourceCurrStatus.getPath() + " to " + target);
                CopyMapper.updateSkipCounters(context, sourceCurrStatus);
                context.write(null, (Object)new Text("SKIP: " + sourceCurrStatus.getPath()));
                if (this.verboseLog) {
                    context.write(null, (Object)new Text("FILE_SKIPPED: source=" + sourceFileStatus.getPath() + ", size=" + sourceFileStatus.getLen() + " --> target=" + target + ", size=" + (targetStatus == null ? 0L : targetStatus.getLen())));
                }
            } else {
                if (sourceCurrStatus.isSplit()) {
                    tmpTarget = DistCpUtils.getSplitChunkPath(target, sourceCurrStatus);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("copying " + sourceCurrStatus + " " + tmpTarget);
                }
                this.copyFileWithRetry(description, sourceCurrStatus, tmpTarget, targetStatus, context, action, fileAttributes);
            }
            DistCpUtils.preserve(target.getFileSystem(this.conf), tmpTarget, sourceCurrStatus, fileAttributes, preserveRawXattrs);
        }
        catch (IOException exception) {
            this.handleFailures(exception, sourceFileStatus, target, context);
        }
    }

    private String getFileType(CopyListingFileStatus fileStatus) {
        if (null == fileStatus) {
            return "N/A";
        }
        return fileStatus.isDirectory() ? "dir" : "file";
    }

    private String getFileType(FileStatus fileStatus) {
        if (null == fileStatus) {
            return "N/A";
        }
        return fileStatus.isDirectory() ? "dir" : "file";
    }

    private static EnumSet<DistCpOptions.FileAttribute> getFileAttributeSettings(Mapper.Context context) {
        String attributeString = context.getConfiguration().get(DistCpOptionSwitch.PRESERVE_STATUS.getConfigLabel());
        return DistCpUtils.unpackAttributes(attributeString);
    }

    private void copyFileWithRetry(String description, CopyListingFileStatus sourceFileStatus, Path target, FileStatus targrtFileStatus, Mapper.Context context, FileAction action, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException, InterruptedException {
        long bytesCopied;
        try {
            bytesCopied = (Long)new RetriableFileCopyCommand(this.skipCrc, description, action, this.directWrite).execute(sourceFileStatus, target, context, fileAttributes);
        }
        catch (Exception e) {
            context.setStatus("Copy Failure: " + sourceFileStatus.getPath());
            throw new IOException("File copy failed: " + sourceFileStatus.getPath() + " --> " + target, e);
        }
        CopyMapper.incrementCounter(context, Counter.BYTESEXPECTED, sourceFileStatus.getLen());
        CopyMapper.incrementCounter(context, Counter.BYTESCOPIED, bytesCopied);
        CopyMapper.incrementCounter(context, Counter.COPY, 1L);
        this.totalBytesCopied += bytesCopied;
        if (this.verboseLog) {
            context.write(null, (Object)new Text("FILE_COPIED: source=" + sourceFileStatus.getPath() + ", size=" + sourceFileStatus.getLen() + " --> target=" + target + ", size=" + (targrtFileStatus == null ? 0L : targrtFileStatus.getLen())));
        }
    }

    private void createTargetDirsWithRetry(String description, Path target, Mapper.Context context) throws IOException {
        try {
            new RetriableDirectoryCreateCommand(description).execute(target, context);
        }
        catch (Exception e) {
            throw new IOException("mkdir failed for " + target, e);
        }
        CopyMapper.incrementCounter(context, Counter.DIR_COPY, 1L);
    }

    private static void updateSkipCounters(Mapper.Context context, CopyListingFileStatus sourceFile) {
        CopyMapper.incrementCounter(context, Counter.SKIP, 1L);
        CopyMapper.incrementCounter(context, Counter.BYTESSKIPPED, sourceFile.getLen());
    }

    private void handleFailures(IOException exception, CopyListingFileStatus sourceFileStatus, Path target, Mapper.Context context) throws IOException, InterruptedException {
        LOG.error("Failure in copying " + sourceFileStatus.getPath() + (sourceFileStatus.isSplit() ? ", offset=" + sourceFileStatus.getChunkOffset() + " chunkLength=" + sourceFileStatus.getChunkLength() : "") + " to " + target, (Throwable)exception);
        if (!this.ignoreFailures || ExceptionUtils.indexOfType((Throwable)exception, RetriableFileCopyCommand.CopyReadException.class) == -1) {
            throw exception;
        }
        CopyMapper.incrementCounter(context, Counter.FAIL, 1L);
        CopyMapper.incrementCounter(context, Counter.BYTESFAILED, sourceFileStatus.getLen());
        context.write(null, (Object)new Text("FAIL: " + sourceFileStatus.getPath() + " - " + StringUtils.stringifyException((Throwable)exception)));
    }

    private static void incrementCounter(Mapper.Context context, Counter counter, long value) {
        context.getCounter((Enum)counter).increment(value);
    }

    private FileAction checkUpdate(FileSystem sourceFS, CopyListingFileStatus source, Path target, FileStatus targetFileStatus) throws IOException {
        if (targetFileStatus != null && !this.overWrite) {
            FileChecksum sourceChecksum;
            long targetLen;
            if (this.canSkip(sourceFS, source, targetFileStatus)) {
                return FileAction.SKIP;
            }
            if (this.append && (targetLen = targetFileStatus.getLen()) < source.getLen() && (sourceChecksum = sourceFS.getFileChecksum(source.getPath(), targetLen)) != null && sourceChecksum.equals((Object)this.targetFS.getFileChecksum(target))) {
                return FileAction.APPEND;
            }
        }
        return FileAction.OVERWRITE;
    }

    private boolean canSkip(FileSystem sourceFS, CopyListingFileStatus source, FileStatus target) throws IOException {
        boolean sameBlockSize;
        if (!this.syncFolders) {
            return true;
        }
        boolean sameLength = target.getLen() == source.getLen();
        boolean bl = sameBlockSize = source.getBlockSize() == target.getBlockSize() || !this.preserve.contains((Object)DistCpOptions.FileAttribute.BLOCKSIZE);
        if (sameLength && sameBlockSize) {
            return this.skipCrc || DistCpUtils.checksumsAreEqual(sourceFS, source.getPath(), null, this.targetFS, target.getPath());
        }
        return false;
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        super.cleanup(context);
        long secs = (System.currentTimeMillis() - this.startEpoch) / 1000L;
        CopyMapper.incrementCounter(context, Counter.BANDWIDTH_IN_BYTES, this.totalBytesCopied / (secs == 0L ? 1L : secs));
    }

    static enum FileAction {
        SKIP,
        APPEND,
        OVERWRITE;

    }

    public static enum Counter {
        COPY,
        DIR_COPY,
        SKIP,
        FAIL,
        BYTESCOPIED,
        BYTESEXPECTED,
        BYTESFAILED,
        BYTESSKIPPED,
        SLEEP_TIME_MS,
        BANDWIDTH_IN_BYTES;

    }
}

