/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.sentry.hdfs.AuthzPermissions;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryPermissions;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipalType;
import org.apache.sentry.hdfs.service.thrift.TRoleChanges;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateableAuthzPermissions
implements AuthzPermissions,
Updateable<PermissionsUpdate> {
    private static final ImmutableMap<String, FsAction> ACTION_MAPPING = ImmutableMap.builder().put((Object)"ALL", (Object)FsAction.ALL).put((Object)"*", (Object)FsAction.ALL).put((Object)"SELECT", (Object)FsAction.READ_EXECUTE).put((Object)"INSERT", (Object)FsAction.WRITE_EXECUTE).build();
    private static final int MAX_UPDATES_PER_LOCK_USE = 99;
    private static final String UPDATABLE_TYPE_NAME = "perm_authz_update";
    private static final Logger LOG = LoggerFactory.getLogger(UpdateableAuthzPermissions.class);
    private final SentryPermissions perms = new SentryPermissions();
    private final AtomicLong seqNum = new AtomicLong(-1L);

    @Override
    public List<AclEntry> getAcls(String authzObj) {
        return this.perms.getAcls(authzObj);
    }

    public UpdateableAuthzPermissions updateFull(PermissionsUpdate update) {
        UpdateableAuthzPermissions other = new UpdateableAuthzPermissions();
        other.applyPartialUpdate(update);
        other.seqNum.set(update.getSeqNum());
        return other;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartial(Iterable<PermissionsUpdate> updates, ReadWriteLock lock) {
        lock.writeLock().lock();
        try {
            int counter = 0;
            for (PermissionsUpdate update : updates) {
                this.applyPartialUpdate(update);
                if (++counter > 99) {
                    counter = 0;
                    lock.writeLock().unlock();
                    lock.writeLock().lock();
                }
                this.seqNum.set(update.getSeqNum());
                LOG.debug("##### Updated perms seq Num [" + this.seqNum.get() + "]");
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private void applyPartialUpdate(PermissionsUpdate update) {
        this.applyPrivilegeUpdates(update);
        this.applyRoleUpdates(update);
    }

    private void applyRoleUpdates(PermissionsUpdate update) {
        for (TRoleChanges rUpdate : update.getRoleUpdates()) {
            LOG.debug("Applying privilege update on role:{} add group {}, role delete group {}", new Object[]{rUpdate.getRole(), rUpdate.getAddGroups(), rUpdate.getDelGroups()});
            if (rUpdate.getRole().equals("__ALL_ROLES__")) {
                String groupToRemove = rUpdate.getDelGroups().iterator().next();
                for (SentryPermissions.RoleInfo rInfo : this.perms.getAllRoles()) {
                    rInfo.delGroup(groupToRemove);
                }
            }
            SentryPermissions.RoleInfo rInfo = this.perms.getRoleInfo(rUpdate.getRole());
            LOG.debug("RoleInfo Before: " + (rInfo != null ? rInfo.toString() : "null"));
            for (String group : rUpdate.getAddGroups()) {
                if (rInfo == null) {
                    rInfo = new SentryPermissions.RoleInfo(rUpdate.getRole());
                }
                rInfo.addGroup(group);
            }
            if (rInfo != null) {
                this.perms.addRoleInfo(rInfo);
                for (String group : rUpdate.getDelGroups()) {
                    if (group.equals("__ALL_GROUPS__")) {
                        this.perms.delRoleInfo(rInfo.getRole());
                        break;
                    }
                    rInfo.delGroup(group);
                }
            }
            LOG.debug("RoleInfo After: " + (rInfo != null ? rInfo.toString() : "null"));
        }
    }

    private void applyPrivilegeUpdates(PermissionsUpdate update) {
        for (TPrivilegeChanges pUpdate : update.getPrivilegeUpdates()) {
            TPrivilegePrincipal delPrivEntity;
            LOG.debug("Applying privilege update on object:{} add privileges {}, delete privileges {}", new Object[]{pUpdate.getAuthzObj(), pUpdate.getAddPrivileges(), pUpdate.getDelPrivileges()});
            if (pUpdate.getAuthzObj().equals("__RENAME_PRIV__")) {
                TPrivilegePrincipal addPrivEntity = pUpdate.getAddPrivileges().keySet().iterator().next();
                delPrivEntity = pUpdate.getDelPrivileges().keySet().iterator().next();
                if (addPrivEntity.getType() != TPrivilegePrincipalType.AUTHZ_OBJ || delPrivEntity.getType() != TPrivilegePrincipalType.AUTHZ_OBJ) {
                    LOG.warn("Invalid Permission Update, Received Rename update with wrong data, (Add) Type: {}, Value:{} (Del) Type: {}, Value:{}", new Object[]{addPrivEntity.getType(), addPrivEntity.getValue(), delPrivEntity.getType(), delPrivEntity.getValue()});
                    continue;
                }
                String newAuthzObj = addPrivEntity.getValue();
                String oldAuthzObj = delPrivEntity.getValue();
                LOG.debug("Performing Rename from {} to {}", (Object)oldAuthzObj, (Object)newAuthzObj);
                SentryPermissions.PrivilegeInfo privilegeInfo = this.perms.getPrivilegeInfo(oldAuthzObj);
                if (privilegeInfo != null) {
                    LOG.debug("Permission info before rename " + privilegeInfo.toString());
                    Map<TPrivilegePrincipal, FsAction> allPermissions = privilegeInfo.getAllPermissions();
                    this.perms.delPrivilegeInfo(oldAuthzObj);
                    this.perms.removeParentChildMappings(oldAuthzObj);
                    SentryPermissions.PrivilegeInfo newPrivilegeInfo = new SentryPermissions.PrivilegeInfo(newAuthzObj);
                    for (Map.Entry entry : allPermissions.entrySet()) {
                        newPrivilegeInfo.setPermission((TPrivilegePrincipal)entry.getKey(), (FsAction)entry.getValue());
                    }
                    this.perms.addPrivilegeInfo(newPrivilegeInfo);
                    this.perms.addParentChildMappings(newAuthzObj);
                    LOG.debug("Permission info before rename " + newPrivilegeInfo.toString());
                }
                return;
            }
            if (pUpdate.getAuthzObj().equals("__ALL_AUTHZ_OBJ__")) {
                delPrivEntity = pUpdate.getDelPrivileges().keySet().iterator().next();
                for (SentryPermissions.PrivilegeInfo pInfo : this.perms.getAllPrivileges()) {
                    LOG.debug("Role {} is revoked permission on {}", (Object)delPrivEntity.getValue(), (Object)pInfo.getAuthzObj());
                    pInfo.removePermission(delPrivEntity);
                }
            }
            this.logPermissionInfo("BEFORE-UPDATE", pUpdate.getAuthzObj());
            SentryPermissions.PrivilegeInfo pInfo = this.perms.getPrivilegeInfo(pUpdate.getAuthzObj());
            for (Map.Entry<TPrivilegePrincipal, String> aMap : pUpdate.getAddPrivileges().entrySet()) {
                FsAction fsAction;
                if (pInfo == null) {
                    pInfo = new SentryPermissions.PrivilegeInfo(pUpdate.getAuthzObj());
                }
                fsAction = (fsAction = pInfo.getPermission(aMap.getKey())) == null ? UpdateableAuthzPermissions.getFAction(aMap.getValue()) : fsAction.or(UpdateableAuthzPermissions.getFAction(aMap.getValue()));
                pInfo.setPermission(aMap.getKey(), fsAction);
            }
            if (pInfo != null) {
                this.perms.addPrivilegeInfo(pInfo);
                this.perms.addParentChildMappings(pUpdate.getAuthzObj());
                for (Map.Entry<TPrivilegePrincipal, String> dMap : pUpdate.getDelPrivileges().entrySet()) {
                    if (dMap.getKey().getValue().equals("__ALL_PRIVS__")) {
                        this.perms.delPrivilegeInfo(pUpdate.getAuthzObj());
                        this.perms.removeParentChildMappings(pUpdate.getAuthzObj());
                        break;
                    }
                    ArrayList<SentryPermissions.PrivilegeInfo> parentAndChild = new ArrayList<SentryPermissions.PrivilegeInfo>();
                    parentAndChild.add(pInfo);
                    Set<String> children = this.perms.getChildren(pInfo.getAuthzObj());
                    if (children != null) {
                        for (String string : children) {
                            parentAndChild.add(this.perms.getPrivilegeInfo(string));
                        }
                    }
                    for (SentryPermissions.PrivilegeInfo privilegeInfo : parentAndChild) {
                        FsAction fsAction = privilegeInfo.getPermission(dMap.getKey());
                        if (fsAction == null) continue;
                        if (FsAction.NONE == (fsAction = fsAction.and(UpdateableAuthzPermissions.getFAction(dMap.getValue()).not()))) {
                            privilegeInfo.removePermission(dMap.getKey());
                            continue;
                        }
                        privilegeInfo.setPermission(dMap.getKey(), fsAction);
                    }
                }
            }
            this.logPermissionInfo("AFTER-UPDATE", pUpdate.getAuthzObj());
        }
    }

    private void logPermissionInfo(String message, String objName) {
        SentryPermissions.PrivilegeInfo pInfo = this.perms.getPrivilegeInfo(objName);
        if (pInfo != null) {
            LOG.debug("{} Permission info for {} is {}", new Object[]{message, objName, pInfo.toString()});
            Set<String> children = this.perms.getChildren(pInfo.getAuthzObj());
            if (children != null) {
                for (String child : children) {
                    SentryPermissions.PrivilegeInfo childInfo = this.perms.getPrivilegeInfo(child);
                    if (childInfo == null || objName.equals(child)) continue;
                    LOG.debug("{} Permission info for {} is {}", new Object[]{message, childInfo.getAuthzObj(), childInfo.toString()});
                }
            }
        }
    }

    private static FsAction getFAction(String sentryPriv) {
        String[] strPrivs = sentryPriv.trim().split(",");
        FsAction retVal = FsAction.NONE;
        for (String strPriv : strPrivs) {
            FsAction action = (FsAction)ACTION_MAPPING.get((Object)strPriv.toUpperCase());
            if (action == null) {
                LOG.warn("Unsupported privilege {}, disabling all access", (Object)strPriv);
                action = FsAction.NONE;
            }
            retVal = retVal.or(action);
        }
        return retVal;
    }

    @Override
    public long getLastUpdatedSeqNum() {
        return this.seqNum.get();
    }

    @Override
    public long getLastUpdatedImgNum() {
        return -1L;
    }

    @Override
    public PermissionsUpdate createFullImageUpdate(long currSeqNum) {
        PermissionsUpdate retVal = new PermissionsUpdate(currSeqNum, true);
        for (SentryPermissions.PrivilegeInfo pInfo : this.perms.getAllPrivileges()) {
            TPrivilegeChanges pUpdate = retVal.addPrivilegeUpdate(pInfo.getAuthzObj());
            for (Map.Entry<TPrivilegePrincipal, FsAction> ent : pInfo.getAllPermissions().entrySet()) {
                pUpdate.putToAddPrivileges(new TPrivilegePrincipal(ent.getKey()), ent.getValue().SYMBOL);
            }
        }
        for (SentryPermissions.RoleInfo rInfo : this.perms.getAllRoles()) {
            TRoleChanges rUpdate = retVal.addRoleUpdate(rInfo.getRole());
            for (String group : rInfo.getAllGroups()) {
                rUpdate.addToAddGroups(group);
            }
        }
        return retVal;
    }

    @Override
    public String getUpdateableTypeName() {
        return UPDATABLE_TYPE_NAME;
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getSimpleName(), this.seqNum, this.perms);
    }

    @Override
    public String getSequenceInfo() {
        return String.format("%s (Perm: Sequence Number %s)", this.getClass().getSimpleName(), this.seqNum);
    }

    public String dumpContent() {
        return String.format("%s(%s) ", this.getClass().getSimpleName(), this.seqNum) + this.perms.dumpContent();
    }
}

