/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.sentry.hdfs.AuthzPaths;
import org.apache.sentry.hdfs.AuthzPathsDumper;
import org.apache.sentry.hdfs.HMSPaths;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPathChanges;
import org.apache.sentry.hdfs.service.thrift.TPathsDump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateableAuthzPaths
implements AuthzPaths,
Updateable<PathsUpdate> {
    private static final int MAX_UPDATES_PER_LOCK_USE = 99;
    private static final String UPDATABLE_TYPE_NAME = "path_update";
    private static final Logger LOG = LoggerFactory.getLogger(UpdateableAuthzPaths.class);
    private volatile HMSPaths paths;
    private final AtomicLong seqNum = new AtomicLong(-1L);
    private final AtomicLong imgNum = new AtomicLong(0L);

    public UpdateableAuthzPaths(String[] pathPrefixes) {
        this.paths = new HMSPaths(pathPrefixes);
    }

    UpdateableAuthzPaths(HMSPaths paths) {
        this.paths = paths;
    }

    @VisibleForTesting
    void setHMSPaths(HMSPaths paths) {
        this.paths = paths;
    }

    @Override
    public boolean isUnderPrefix(String[] pathElements) {
        return this.paths.isUnderPrefix(pathElements);
    }

    @Override
    public Set<String> findAuthzObject(String[] pathElements) {
        return this.paths.findAuthzObject(pathElements);
    }

    @Override
    public Set<String> findAuthzObjectExactMatches(String[] pathElements) {
        return this.paths.findAuthzObjectExactMatches(pathElements);
    }

    public UpdateableAuthzPaths updateFull(PathsUpdate update) {
        UpdateableAuthzPaths other = this.getPathsDump().initializeFromDump(update.toThrift().getPathsDump());
        other.seqNum.set(update.getSeqNum());
        other.imgNum.set(update.getImgNum());
        return other;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartial(Iterable<PathsUpdate> updates, ReadWriteLock lock) {
        lock.writeLock().lock();
        try {
            int counter = 0;
            for (PathsUpdate update : updates) {
                this.applyPartialUpdate(update);
                if (++counter > 99) {
                    counter = 0;
                    lock.writeLock().unlock();
                    lock.writeLock().lock();
                }
                this.seqNum.set(update.getSeqNum());
                if (this.imgNum.get() < update.getImgNum()) {
                    this.imgNum.set(update.getImgNum());
                }
                LOG.debug("##### Updated paths seq Num [{}] img Num [{}]", (Object)this.seqNum.get(), (Object)this.imgNum.get());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    private void applyPartialUpdate(PathsUpdate update) {
        if (update.getPathChanges().size() == 2) {
            List<TPathChanges> pathChanges = update.getPathChanges();
            TPathChanges newPathInfo = null;
            TPathChanges oldPathInfo = null;
            if (pathChanges.get(0).getAddPathsSize() == 1 && pathChanges.get(1).getDelPathsSize() == 1) {
                newPathInfo = pathChanges.get(0);
                oldPathInfo = pathChanges.get(1);
            } else if (pathChanges.get(1).getAddPathsSize() == 1 && pathChanges.get(0).getDelPathsSize() == 1) {
                newPathInfo = pathChanges.get(1);
                oldPathInfo = pathChanges.get(0);
            }
            if (newPathInfo != null && oldPathInfo != null && !newPathInfo.getAuthzObj().equalsIgnoreCase(oldPathInfo.getAuthzObj())) {
                LOG.info("Renaming Object:{} to {}", (Object)oldPathInfo.getAuthzObj(), (Object)newPathInfo.getAuthzObj());
                this.paths.renameAuthzObject(oldPathInfo.getAuthzObj(), oldPathInfo.getDelPaths(), newPathInfo.getAuthzObj(), newPathInfo.getAddPaths());
                return;
            }
        }
        ArrayList<TPathChanges> deletePathChanges = new ArrayList<TPathChanges>();
        ArrayList<TPathChanges> addPathChanges = new ArrayList<TPathChanges>();
        for (TPathChanges pathChanges : update.getPathChanges()) {
            if (pathChanges.getDelPaths() != null && pathChanges.getDelPaths().size() != 0) {
                deletePathChanges.add(pathChanges);
            }
            if (pathChanges.getAddPaths() == null || pathChanges.getAddPaths().size() == 0) continue;
            addPathChanges.add(pathChanges);
        }
        for (TPathChanges pathChanges : deletePathChanges) {
            List<List<String>> delPaths = pathChanges.getDelPaths();
            if (delPaths.size() == 1 && delPaths.get(0).size() == 1 && delPaths.get(0).get(0).equals("__ALL_PATHS__")) {
                LOG.info("Applying Path update. Deleting all paths for authz obj {}", (Object)pathChanges.getAuthzObj());
                this.paths.deleteAuthzObject(pathChanges.getAuthzObj());
                continue;
            }
            LOG.info("Applying Path update. Deleting path for authz object: {} authz path: {}", (Object)pathChanges.getAuthzObj(), pathChanges.getDelPaths());
            this.paths.deletePathsFromAuthzObject(pathChanges.getAuthzObj(), pathChanges.getDelPaths());
        }
        for (TPathChanges pathChanges : addPathChanges) {
            LOG.info("Applying Path update. Adding path for authz object {} authz path {}", (Object)pathChanges.getAuthzObj(), pathChanges.getAddPaths());
            this.applyAddChanges(pathChanges.getAuthzObj(), pathChanges.getAddPaths());
        }
    }

    public void applyAddChanges(String objName, List<List<String>> changes) {
        this.paths.addPathsToAuthzObject(objName, changes, true);
    }

    @Override
    public long getLastUpdatedSeqNum() {
        return this.seqNum.get();
    }

    @Override
    public long getLastUpdatedImgNum() {
        return this.imgNum.get();
    }

    @Override
    public PathsUpdate createFullImageUpdate(long currSeqNum) {
        PathsUpdate pathsUpdate = new PathsUpdate(currSeqNum, true);
        pathsUpdate.toThrift().setPathsDump(this.getPathsDump().createPathsDump(true));
        return pathsUpdate;
    }

    public AuthzPathsDumper<UpdateableAuthzPaths> getPathsDump() {
        return new AuthzPathsDumper<UpdateableAuthzPaths>(){

            @Override
            public TPathsDump createPathsDump(boolean minimizeSize) {
                return UpdateableAuthzPaths.this.paths.getPathsDump().createPathsDump(minimizeSize);
            }

            @Override
            public UpdateableAuthzPaths initializeFromDump(TPathsDump pathsDump) {
                return new UpdateableAuthzPaths(UpdateableAuthzPaths.this.paths.getPathsDump().initializeFromDump(pathsDump));
            }
        };
    }

    @Override
    public String getUpdateableTypeName() {
        return UPDATABLE_TYPE_NAME;
    }

    public String toString() {
        return String.format("%s(%s, %s, %s)", this.getClass().getSimpleName(), this.seqNum, this.imgNum, this.paths);
    }

    @Override
    public String getSequenceInfo() {
        return String.format("%s(Path: Sequence Number %s, Image Number: %s)", this.getClass().getSimpleName(), this.seqNum, this.imgNum);
    }

    public String dumpContent() {
        return String.format("%s(%s, %s) ", this.getClass().getSimpleName(), this.seqNum, this.imgNum) + this.paths.dumpContent();
    }
}

