/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.common.SentryServiceUtil;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.api.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.api.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.api.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.api.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryGroup;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.core.common.exception.SentryInvalidInputException;
import org.apache.sentry.core.common.utils.PubSub;
import org.apache.sentry.core.common.utils.SentryUtils;
import org.apache.sentry.core.common.utils.SigUtils;
import org.apache.sentry.hdfs.DBUpdateForwarder;
import org.apache.sentry.hdfs.PathDeltaRetriever;
import org.apache.sentry.hdfs.PathImageRetriever;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermDeltaRetriever;
import org.apache.sentry.hdfs.PermImageRetriever;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.ServiceConstants;
import org.apache.sentry.hdfs.Updateable;
import org.apache.sentry.hdfs.service.thrift.TPrivilegeChanges;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipal;
import org.apache.sentry.hdfs.service.thrift.TPrivilegePrincipalType;
import org.apache.sentry.hdfs.service.thrift.TRoleChanges;
import org.apache.sentry.provider.db.SentryPolicyStorePlugin;
import org.apache.sentry.provider.db.service.persistent.SentryStoreInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryPlugin
implements SentryPolicyStorePlugin,
SigUtils.SigListener,
PubSub.Subscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryPlugin.class);
    private static final String FULL_UPDATE_TRIGGER = "FULL UPDATE TRIGGER: ";
    private final AtomicBoolean fullUpdateNN = new AtomicBoolean(false);
    public static volatile SentryPlugin instance;
    private DBUpdateForwarder<PathsUpdate> pathsUpdater;
    private DBUpdateForwarder<PermissionsUpdate> permsUpdater;

    public void initialize(Configuration conf, SentryStoreInterface sentryStore) throws SentryPolicyStorePlugin.SentryPluginException {
        String[] prefixes = conf.getStrings("sentry.hdfs.integration.path.prefixes", ServiceConstants.ServerConfig.SENTRY_HDFS_INTEGRATION_PATH_PREFIXES_DEFAULT);
        PermImageRetriever permImageRetriever = new PermImageRetriever(sentryStore);
        PathImageRetriever pathImageRetriever = new PathImageRetriever(sentryStore, prefixes);
        PermDeltaRetriever permDeltaRetriever = new PermDeltaRetriever(sentryStore);
        PathDeltaRetriever pathDeltaRetriever = new PathDeltaRetriever(sentryStore);
        this.pathsUpdater = new DBUpdateForwarder<PathsUpdate>(pathImageRetriever, pathDeltaRetriever);
        this.permsUpdater = new DBUpdateForwarder<PermissionsUpdate>(permImageRetriever, permDeltaRetriever);
        LOGGER.info("Sentry HDFS plugin initialized !!");
        instance = this;
        String[] sigs = conf.getStrings("sentry.hdfs.sync.full-update-signal", null);
        if (sigs != null && sigs.length != 0) {
            for (String sig : sigs) {
                try {
                    LOGGER.info("SIGNAL HANDLING: Registering Signal Handler For " + sig);
                    SigUtils.registerSigListener(sig, this);
                }
                catch (Exception e) {
                    LOGGER.error("SIGNAL HANDLING: Signal Handle Registration Failure", (Throwable)e);
                }
            }
        }
        if (conf.getBoolean("sentry.hdfs.sync.full-update-pubsub", false)) {
            LOGGER.info("FULL UPDATE TRIGGER: subscribing to topic " + PubSub.Topic.HDFS_SYNC_NN.getName());
            PubSub.getInstance().subscribe(PubSub.Topic.HDFS_SYNC_NN, this);
        }
    }

    public List<PathsUpdate> getAllPathsUpdatesFrom(long pathSeqNum, long pathImgNum) throws Exception {
        if (!this.fullUpdateNN.get()) {
            LOGGER.debug("Received request for PATH update from NameNode for pathSeqNum {} and pathImgNum {}", (Object)pathSeqNum, (Object)pathImgNum);
            return this.pathsUpdater.getAllUpdatesFrom(pathSeqNum, pathImgNum);
        }
        LOGGER.info("FULL UPDATE TRIGGER: sending full PATH update to NameNode");
        this.fullUpdateNN.set(false);
        List<PathsUpdate> updates = this.pathsUpdater.getAllUpdatesFrom(-1L, 0L);
        if (updates != null) {
            if (!updates.isEmpty()) {
                if (updates.get(0).hasFullImage()) {
                    LOGGER.info("FULL UPDATE TRIGGER: Confirmed full PATH update to NameNode for pathSeqNum {} and pathImgNum {}", (Object)pathSeqNum, (Object)pathImgNum);
                } else {
                    LOGGER.warn("FULL UPDATE TRIGGER: Sending partial instead of full PATH update to NameNode  for pathSeqNum {} and pathImgNum {} (???)", (Object)pathSeqNum, (Object)pathImgNum);
                }
            } else {
                LOGGER.warn("FULL UPDATE TRIGGER: Sending empty instead of full PATH update to NameNode  for pathSeqNum {} and pathImgNum {} (???)", (Object)pathSeqNum, (Object)pathImgNum);
            }
        } else {
            LOGGER.warn("FULL UPDATE TRIGGER: returned NULL instead of full PATH update to NameNode  for pathSeqNum {} and pathImgNum {} (???)", (Object)pathSeqNum, (Object)pathImgNum);
        }
        return updates;
    }

    public List<PermissionsUpdate> getAllPermsUpdatesFrom(long permSeqNum) throws Exception {
        LOGGER.debug("Received request for PERM update from NameNode for permSeqNum {}", (Object)permSeqNum);
        return this.permsUpdater.getAllUpdatesFrom(permSeqNum, -1L);
    }

    public Updateable.Update onAlterSentryRoleAddGroups(TAlterSentryRoleAddGroupsRequest request) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleAddGroups: {}", (Object)request);
        }
        PermissionsUpdate update = new PermissionsUpdate();
        TRoleChanges rUpdate = update.addRoleUpdate(request.getRoleName());
        for (TSentryGroup group : request.getGroups()) {
            rUpdate.addToAddGroups(group.getGroupName());
        }
        LOGGER.debug(String.format("onAlterSentryRoleAddGroups, Authz Perm preUpdate[ %s ]", request.getRoleName()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleAddGroups: {}", (Object)update);
        }
        return update;
    }

    public Updateable.Update onAlterSentryRoleDeleteGroups(TAlterSentryRoleDeleteGroupsRequest request) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleDeleteGroups: {}", (Object)request);
        }
        PermissionsUpdate update = new PermissionsUpdate();
        TRoleChanges rUpdate = update.addRoleUpdate(request.getRoleName());
        for (TSentryGroup group : request.getGroups()) {
            rUpdate.addToDelGroups(group.getGroupName());
        }
        LOGGER.debug(String.format("onAlterSentryRoleDeleteGroups, Authz Perm preUpdate [ %s ]", request.getRoleName()));
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleDeleteGroups: {}", (Object)update);
        }
        return update;
    }

    public void onAlterSentryRoleGrantPrivilege(String roleName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)roleName, (Object)"Role name is NULL");
        Preconditions.checkNotNull(privilegesUpdateMap, (Object)"Privilege MAP NULL");
        Preconditions.checkNotNull(privileges, (Object)"Privilege Set provided is NULL");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleGrantPrivilege: {}", (Object)roleName, privileges);
        }
        if (privileges.size() > 0) {
            for (TSentryPrivilege privilege : privileges) {
                PermissionsUpdate update;
                if (ApiConstants.PrivilegeScope.COLUMN.name().equalsIgnoreCase(privilege.getPrivilegeScope()) || (update = this.onAlterSentryGrantPrivilegeCore(new TPrivilegePrincipal(TPrivilegePrincipalType.ROLE, roleName), privilege)) == null || privilegesUpdateMap == null) continue;
                privilegesUpdateMap.put(privilege, update);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleGrantPrivilege: {}", privilegesUpdateMap);
        }
    }

    public void onAlterSentryUserGrantPrivilege(String userName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)userName, (Object)"User name is NULL");
        Preconditions.checkNotNull(privilegesUpdateMap, (Object)"Privilege MAP NULL");
        Preconditions.checkNotNull(privileges, (Object)"Privilege Set provided is NULL");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryUserGrantPrivilege: {}", (Object)userName, privileges);
        }
        if (privileges.size() > 0) {
            for (TSentryPrivilege privilege : privileges) {
                PermissionsUpdate update;
                if (ApiConstants.PrivilegeScope.COLUMN.name().equalsIgnoreCase(privilege.getPrivilegeScope()) || (update = this.onAlterSentryGrantPrivilegeCore(new TPrivilegePrincipal(TPrivilegePrincipalType.USER, userName), privilege)) == null || privilegesUpdateMap == null) continue;
                privilegesUpdateMap.put(privilege, update);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryUserGrantPrivilege: {}", privilegesUpdateMap);
        }
    }

    private PermissionsUpdate onAlterSentryGrantPrivilegeCore(TPrivilegePrincipal TPrivilegePrincipal2, TSentryPrivilege privilege) throws SentryPolicyStorePlugin.SentryPluginException {
        String authzObj = this.getAuthzObj(privilege);
        if (authzObj == null) {
            return null;
        }
        PermissionsUpdate update = new PermissionsUpdate();
        update.addPrivilegeUpdate(authzObj).putToAddPrivileges(TPrivilegePrincipal2, privilege.getAction().toUpperCase());
        LOGGER.debug(String.format("onAlterSentryRoleGrantPrivilegeCore, Authz Perm preUpdate [ %s ]", authzObj));
        return update;
    }

    public Updateable.Update onRenameSentryPrivilege(TRenamePrivilegesRequest request) throws SentryPolicyStorePlugin.SentryPluginException, SentryInvalidInputException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onRenameSentryPrivilege: {}", (Object)request);
        }
        String oldAuthz = null;
        String newAuthz = null;
        try {
            oldAuthz = SentryServiceUtil.getAuthzObj((TSentryAuthorizable)request.getOldAuthorizable());
            newAuthz = SentryServiceUtil.getAuthzObj((TSentryAuthorizable)request.getNewAuthorizable());
        }
        catch (SentryInvalidInputException failure) {
            LOGGER.error("onRenameSentryPrivilege, Could not rename sentry privilege ", (Throwable)failure);
            throw failure;
        }
        PermissionsUpdate update = new PermissionsUpdate();
        TPrivilegeChanges privUpdate = update.addPrivilegeUpdate("__RENAME_PRIV__");
        privUpdate.putToAddPrivileges(new TPrivilegePrincipal(TPrivilegePrincipalType.AUTHZ_OBJ, newAuthz), newAuthz);
        privUpdate.putToDelPrivileges(new TPrivilegePrincipal(TPrivilegePrincipalType.AUTHZ_OBJ, oldAuthz), oldAuthz);
        LOGGER.debug("onRenameSentryPrivilege, Authz Perm preUpdate [ {} ]", (Object)oldAuthz);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onRenameSentryPrivilege: {}", (Object)update);
        }
        return update;
    }

    public void onAlterSentryRoleRevokePrivilege(String roleName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)roleName, (Object)"Role name is NULL");
        Preconditions.checkNotNull(privilegesUpdateMap, (Object)"Privilege MAP NULL");
        Preconditions.checkNotNull(privileges, (Object)"Privilege Set provided is NULL");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleRevokePrivilege: {}", (Object)roleName, privileges);
        }
        if (privileges.size() > 0) {
            for (TSentryPrivilege privilege : privileges) {
                PermissionsUpdate update;
                if ("COLUMN".equalsIgnoreCase(privilege.getPrivilegeScope()) || (update = this.onAlterSentryRevokePrivilegeCore(new TPrivilegePrincipal(TPrivilegePrincipalType.ROLE, roleName), privilege)) == null || privilegesUpdateMap == null) continue;
                privilegesUpdateMap.put(privilege, update);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryRoleRevokePrivilege: {}", privilegesUpdateMap);
        }
    }

    public void onAlterSentryUserRevokePrivilege(String userName, Set<TSentryPrivilege> privileges, Map<TSentryPrivilege, Updateable.Update> privilegesUpdateMap) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)userName, (Object)"User name is NULL");
        Preconditions.checkNotNull(privilegesUpdateMap, (Object)"Privilege MAP NULL");
        Preconditions.checkNotNull(privileges, (Object)"Privilege Set provided is NULL");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryUserRevokePrivilege: {}", (Object)userName, privileges);
        }
        if (privileges.size() > 0) {
            for (TSentryPrivilege privilege : privileges) {
                PermissionsUpdate update;
                if ("COLUMN".equalsIgnoreCase(privilege.getPrivilegeScope()) || (update = this.onAlterSentryRevokePrivilegeCore(new TPrivilegePrincipal(TPrivilegePrincipalType.USER, userName), privilege)) == null || privilegesUpdateMap == null) continue;
                privilegesUpdateMap.put(privilege, update);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onAlterSentryUserRevokePrivilege: {}", privilegesUpdateMap);
        }
    }

    private PermissionsUpdate onAlterSentryRevokePrivilegeCore(TPrivilegePrincipal TPrivilegePrincipal2, TSentryPrivilege privilege) throws SentryPolicyStorePlugin.SentryPluginException {
        String authzObj = this.getAuthzObj(privilege);
        if (authzObj == null) {
            return null;
        }
        PermissionsUpdate update = new PermissionsUpdate();
        update.addPrivilegeUpdate(authzObj).putToDelPrivileges(TPrivilegePrincipal2, privilege.getAction().toUpperCase());
        LOGGER.debug("onAlterSentryRoleRevokePrivilegeCore, Authz Perm preUpdate [ {} ]", (Object)authzObj);
        return update;
    }

    public Updateable.Update onDropSentryRole(TDropSentryRoleRequest request) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onDropSentryRole: {}", (Object)request);
        }
        PermissionsUpdate update = new PermissionsUpdate();
        update.addPrivilegeUpdate("__ALL_AUTHZ_OBJ__").putToDelPrivileges(new TPrivilegePrincipal(TPrivilegePrincipalType.ROLE, request.getRoleName()), "__ALL_AUTHZ_OBJ__");
        update.addRoleUpdate(request.getRoleName()).addToDelGroups("__ALL_GROUPS__");
        LOGGER.debug("onDropSentryRole, Authz Perm preUpdate [ {} ]", (Object)request.getRoleName());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onDropSentryRole: {}", (Object)update);
        }
        return update;
    }

    public Updateable.Update onDropSentryPrivilege(TDropPrivilegesRequest request) throws SentryPolicyStorePlugin.SentryPluginException {
        Preconditions.checkNotNull((Object)request, (Object)"request");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onDropSentryPrivilege: {}", (Object)request);
        }
        PermissionsUpdate update = new PermissionsUpdate();
        String authzObj = null;
        try {
            authzObj = SentryServiceUtil.getAuthzObj((TSentryAuthorizable)request.getAuthorizable());
        }
        catch (SentryInvalidInputException failure) {
            LOGGER.error("onDropSentryPrivilege, Could not drop sentry privilege " + failure.toString(), (Throwable)failure);
            throw new SentryPolicyStorePlugin.SentryPluginException(failure.getMessage(), (Throwable)failure);
        }
        update.addPrivilegeUpdate(authzObj).putToDelPrivileges(new TPrivilegePrincipal(TPrivilegePrincipalType.ROLE, "__ALL_PRIVS__"), "__ALL_PRIVS__");
        LOGGER.debug("onDropSentryPrivilege, Authz Perm preUpdate [ {} ]", (Object)authzObj);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("onDropSentryPrivilege: {}", (Object)update);
        }
        return update;
    }

    @Override
    public void onSignal(String sigName) {
        LOGGER.info("SIGNAL HANDLING: Received signal " + sigName + ", triggering full update");
        this.fullUpdateNN.set(true);
    }

    @Override
    public void onMessage(PubSub.Topic topic, String message) {
        Preconditions.checkArgument((topic == PubSub.Topic.HDFS_SYNC_NN ? 1 : 0) != 0, (String)"Unexpected topic %s instead of %s", (Object[])new Object[]{topic, PubSub.Topic.HDFS_SYNC_NN});
        LOGGER.info("FULL UPDATE TRIGGER: Received [{}, {}] notification", (Object)topic, (Object)message);
        this.fullUpdateNN.set(true);
    }

    private String getAuthzObj(TSentryPrivilege privilege) {
        String authzObj = null;
        if (!SentryUtils.isNULL(privilege.getDbName())) {
            String dbName = privilege.getDbName();
            String tblName = privilege.getTableName();
            authzObj = SentryUtils.isNULL(tblName) ? dbName : dbName + "." + tblName;
        }
        return authzObj == null ? null : authzObj.toLowerCase();
    }
}

