/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.transport.RetryClientInvocationHandler;
import org.apache.sentry.core.common.transport.SentryHDFSClientTransportConfig;
import org.apache.sentry.core.common.transport.SentryTransportFactory;
import org.apache.sentry.core.common.transport.SentryTransportPool;
import org.apache.sentry.hdfs.SentryHDFSServiceClient;
import org.apache.sentry.hdfs.SentryHDFSServiceClientDefaultImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class SentryHDFSServiceClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHDFSServiceClientFactory.class);
    private static final AtomicReference<SentryHDFSServiceClientFactory> clientFactory = new AtomicReference();
    private final SentryHDFSClientTransportConfig transportConfig = new SentryHDFSClientTransportConfig();
    private final Configuration conf;
    private final SentryTransportPool transportPool;

    public static SentryHDFSServiceClient create(Configuration conf) throws Exception {
        SentryHDFSServiceClientFactory factory = clientFactory.get();
        if (factory != null) {
            return factory.create();
        }
        factory = new SentryHDFSServiceClientFactory(conf);
        boolean ok = clientFactory.compareAndSet(null, factory);
        if (ok) {
            return factory.create();
        }
        factory.close();
        return clientFactory.get().create();
    }

    private SentryHDFSServiceClientFactory(Configuration conf) {
        this.conf = conf;
        this.transportPool = new SentryTransportPool(conf, this.transportConfig, new SentryTransportFactory(conf, this.transportConfig));
    }

    private SentryHDFSServiceClient create() throws Exception {
        return (SentryHDFSServiceClient)Proxy.newProxyInstance(SentryHDFSServiceClientDefaultImpl.class.getClassLoader(), SentryHDFSServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new RetryClientInvocationHandler(this.conf, new SentryHDFSServiceClientDefaultImpl(this.conf, this.transportPool), this.transportConfig));
    }

    public static void factoryReset() {
        LOGGER.debug("factory reset");
        SentryHDFSServiceClientFactory factory = clientFactory.getAndSet(null);
        if (factory != null) {
            try {
                factory.transportPool.close();
            }
            catch (Exception e) {
                LOGGER.error("failed to close transport pool", (Throwable)e);
            }
        }
    }

    private void close() {
        try {
            this.transportPool.close();
        }
        catch (Exception e) {
            LOGGER.error("failed to close transport pool", (Throwable)e);
        }
    }
}

