/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.hdfs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.exception.SentryHdfsServiceException;
import org.apache.sentry.core.common.transport.SentryConnection;
import org.apache.sentry.core.common.transport.SentryTransportPool;
import org.apache.sentry.core.common.transport.TTransportWrapper;
import org.apache.sentry.hdfs.PathsUpdate;
import org.apache.sentry.hdfs.PermissionsUpdate;
import org.apache.sentry.hdfs.SentryAuthzUpdate;
import org.apache.sentry.hdfs.SentryHDFSServiceClient;
import org.apache.sentry.hdfs.service.thrift.SentryHDFSService;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateRequest;
import org.apache.sentry.hdfs.service.thrift.TAuthzUpdateResponse;
import org.apache.sentry.hdfs.service.thrift.TPathsUpdate;
import org.apache.sentry.hdfs.service.thrift.TPermissionsUpdate;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryHDFSServiceClientDefaultImpl
implements SentryHDFSServiceClient,
SentryConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryHDFSServiceClientDefaultImpl.class);
    private final boolean useCompactTransport;
    private SentryHDFSService.Client client;
    private final SentryTransportPool transportPool;
    private TTransportWrapper transport;
    private final long maxMessageSize;

    SentryHDFSServiceClientDefaultImpl(Configuration conf, SentryTransportPool transportPool) {
        this.maxMessageSize = conf.getLong("sentry.hdfs.thrift.max.message.size", 0x6400000L);
        this.useCompactTransport = conf.getBoolean("sentry.hdfs.service.client.compact.transport", false);
        this.transportPool = transportPool;
    }

    @Override
    public void connect() throws Exception {
        if (this.transport != null && this.transport.isOpen()) {
            return;
        }
        this.transport = this.transportPool.getTransport();
        TProtocol tProtocol = this.useCompactTransport ? new TCompactProtocol(this.transport.getTTransport(), this.maxMessageSize, this.maxMessageSize) : new TBinaryProtocol(this.transport.getTTransport(), this.maxMessageSize, this.maxMessageSize, true, true);
        TMultiplexedProtocol protocol = new TMultiplexedProtocol(tProtocol, "SentryHDFSService");
        this.client = new SentryHDFSService.Client(protocol);
    }

    @Override
    public SentryAuthzUpdate getAllUpdatesFrom(long permSeqNum, long pathSeqNum) throws SentryHdfsServiceException {
        return this.getAllUpdatesFrom(permSeqNum, pathSeqNum, -1L);
    }

    @Override
    public SentryAuthzUpdate getAllUpdatesFrom(long permSeqNum, long pathSeqNum, long pathImgNum) throws SentryHdfsServiceException {
        try {
            LOGGER.debug("Requesting updates: Perm sequence num:{}, Path sequence num: {}, Path Image Number: {})", new Object[]{permSeqNum, pathSeqNum, pathImgNum});
            TAuthzUpdateRequest updateRequest = new TAuthzUpdateRequest(permSeqNum, pathSeqNum, pathImgNum);
            TAuthzUpdateResponse sentryUpdates = this.client.get_authz_updates(updateRequest);
            List<PathsUpdate> pathsUpdates = Collections.emptyList();
            if (sentryUpdates.getAuthzPathUpdate() != null) {
                pathsUpdates = new ArrayList(sentryUpdates.getAuthzPathUpdate().size());
                for (TPathsUpdate pathsUpdate : sentryUpdates.getAuthzPathUpdate()) {
                    pathsUpdates.add(new PathsUpdate(pathsUpdate));
                }
            }
            List<PermissionsUpdate> permsUpdates = Collections.emptyList();
            if (sentryUpdates.getAuthzPermUpdate() != null) {
                permsUpdates = new ArrayList(sentryUpdates.getAuthzPermUpdate().size());
                for (TPermissionsUpdate permsUpdate : sentryUpdates.getAuthzPermUpdate()) {
                    permsUpdates.add(new PermissionsUpdate(permsUpdate));
                }
            }
            if (!(!LOGGER.isDebugEnabled() || permsUpdates.isEmpty() && pathsUpdates.isEmpty())) {
                LOGGER.debug("Requesting updates: Perm sequence num:{}, Path sequence num: {}, Path Image Number: {})", new Object[]{permSeqNum, pathSeqNum, pathImgNum});
                if (LOGGER.isTraceEnabled()) {
                    if (!permsUpdates.isEmpty()) {
                        LOGGER.trace("permsUpdates{}", permsUpdates);
                    }
                    if (!pathsUpdates.isEmpty()) {
                        LOGGER.trace("pathsUpdates{}", pathsUpdates);
                    }
                }
            }
            return new SentryAuthzUpdate(permsUpdates, pathsUpdates);
        }
        catch (Exception e) {
            throw new SentryHdfsServiceException("Thrift Exception occurred !!", e);
        }
    }

    @Override
    public void close() {
        this.done();
    }

    @Override
    public void done() {
        if (this.transport != null) {
            this.transportPool.returnTransport(this.transport);
            this.transport = null;
        }
    }

    @Override
    public void invalidate() {
        if (this.transport != null) {
            this.transportPool.invalidateTransport(this.transport);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("invalidate: " + this.transport);
            }
            this.transport = null;
        }
    }
}

