/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class SigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SigUtils.class);
    private static Map<String, SigHandler> sigHandlerMap = new HashMap<String, SigHandler>();

    private SigUtils() {
    }

    public static void registerSigListener(String sigName, SigListener sigListener) {
        if (StringUtils.isEmpty((String)sigName)) {
            throw new IllegalArgumentException("NULL signal name");
        }
        if (sigListener == null) {
            throw new IllegalArgumentException("NULL signal listener");
        }
        if (!sigHandlerMap.containsKey(sigName)) {
            sigHandlerMap.put(sigName, new SigHandler());
        }
        SigHandler sigHandler = sigHandlerMap.get(sigName);
        sigHandler.addListener(sigListener);
        Signal.handle(new Signal(sigName), sigHandler);
        LOGGER.info("Signal Listener registered for signal " + sigName);
    }

    public static void unregisterSigListener(String sigName, SigListener sigListener) {
        if (StringUtils.isEmpty((String)sigName)) {
            throw new IllegalArgumentException("NULL signal name");
        }
        if (sigListener == null) {
            throw new IllegalArgumentException("NULL signal listener");
        }
        if (!sigHandlerMap.containsKey(sigName)) {
            sigHandlerMap.get(sigName).removeListener(sigListener);
        }
    }

    private static class SigHandler
    implements SignalHandler {
        private final Set<SigListener> listeners = new HashSet<SigListener>();

        SigHandler() {
        }

        public void addListener(SigListener sigListener) {
            this.listeners.add(sigListener);
        }

        public void removeListener(SigListener sigListener) {
            this.listeners.remove(sigListener);
        }

        @Override
        public void handle(Signal sig) {
            if (sig != null) {
                for (SigListener listener : this.listeners) {
                    try {
                        LOGGER.debug("Running Signal Handler {}.onSignal()", (Object)listener.getClass().getName());
                        listener.onSignal(sig.toString());
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("Signal handler %s.onSignal() threw an exception:", listener.getClass().getName()), (Throwable)e);
                    }
                }
                LOGGER.info("Signal propagated: " + sig);
            } else {
                LOGGER.error("Internal Error: null signal received");
            }
        }
    }

    public static interface SigListener {
        public void onSignal(String var1);
    }
}

