/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.db;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.common.ImplyMethodType;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.HiveActionFactory;
import org.apache.sentry.core.model.db.validator.DatabaseMustMatch;
import org.apache.sentry.core.model.db.validator.DatabaseRequiredInPrivilege;
import org.apache.sentry.core.model.db.validator.ServerNameMustMatch;
import org.apache.sentry.core.model.db.validator.ServersAllIsInvalid;

public class HivePrivilegeModel
implements Model {
    private Map<String, ImplyMethodType> implyMethodMap = new HashMap<String, ImplyMethodType>();
    private BitFieldActionFactory bitFieldActionFactory = new HiveActionFactory();
    private static HivePrivilegeModel hivePrivilegeModel = new HivePrivilegeModel();

    private HivePrivilegeModel() {
        this.implyMethodMap.put(DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(DBModelAuthorizable.AuthorizableType.Column.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), ImplyMethodType.URL);
    }

    public Map<String, ImplyMethodType> getImplyMethodMap() {
        return this.implyMethodMap;
    }

    public BitFieldActionFactory getBitFieldActionFactory() {
        return this.bitFieldActionFactory;
    }

    public static HivePrivilegeModel getInstance() {
        return hivePrivilegeModel;
    }

    public ImmutableList<PrivilegeValidator> getPrivilegeValidators(String serverName) {
        return ImmutableList.of((Object)new ServersAllIsInvalid(), (Object)new DatabaseMustMatch(), (Object)new DatabaseRequiredInPrivilege(), (Object)new ServerNameMustMatch(serverName));
    }
}

