/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.db;

import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.core.model.db.View;

public class DBModelAuthorizables {
    private DBModelAuthorizables() {
    }

    public static DBModelAuthorizable from(KeyValue keyValue) {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue();
        for (DBModelAuthorizable.AuthorizableType type : DBModelAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            if (prefix.equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.URI.toString())) {
                return DBModelAuthorizables.from(type, name);
            }
            return DBModelAuthorizables.from(type, name.toLowerCase());
        }
        return null;
    }

    public static DBModelAuthorizable from(String s) {
        return DBModelAuthorizables.from(new KeyValue(s));
    }

    private static DBModelAuthorizable from(DBModelAuthorizable.AuthorizableType type, String name) {
        switch (type) {
            case Server: {
                return new Server(name);
            }
            case Db: {
                return new Database(name);
            }
            case Table: {
                return new Table(name);
            }
            case View: {
                return new View(name);
            }
            case Column: {
                return new Column(name);
            }
            case URI: {
                return new AccessURI(name);
            }
        }
        return null;
    }
}

