/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.policy.common.Privilege;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePrivilegeNode {
    Set<Privilege> ownPrivileges;
    Set<Privilege> childWildcardPrivileges;
    Map<String, TreePrivilegeNode> childPrivileges;
    private static final Logger LOGGER = LoggerFactory.getLogger(TreePrivilegeNode.class);

    public void addPrivilege(Privilege inPrivilege, int partIndex) {
        TreePrivilegeNode childNode;
        if (this.isOwnPrivilege(inPrivilege, partIndex)) {
            if (this.ownPrivileges == null) {
                this.ownPrivileges = new HashSet<Privilege>();
            }
            this.ownPrivileges.add(inPrivilege);
            return;
        }
        String childResourceValue = TreePrivilegeNode.getResourceValue(partIndex + 1, inPrivilege);
        if (StringUtils.isEmpty((String)childResourceValue)) {
            LOGGER.warn("Child resource value at index [{}] of privilege {} is null", (Object)partIndex, (Object)inPrivilege.toString());
            return;
        }
        if (TreePrivilegeNode.isResourceValueWildcard(childResourceValue)) {
            if (this.childWildcardPrivileges == null) {
                this.childWildcardPrivileges = new HashSet<Privilege>();
            }
            this.childWildcardPrivileges.add(inPrivilege);
            return;
        }
        if (this.childPrivileges == null) {
            this.childPrivileges = new HashMap<String, TreePrivilegeNode>();
        }
        if ((childNode = this.childPrivileges.get(childResourceValue)) == null) {
            childNode = new TreePrivilegeNode();
            this.childPrivileges.put(childResourceValue, childNode);
        }
        childNode.addPrivilege(inPrivilege, partIndex + 1);
    }

    public Set<Privilege> listPrivilegeObjects(int partIndex, Authorizable ... authorizationhierarchy) {
        Set<Privilege> childPrivileges;
        if (authorizationhierarchy.length < partIndex + 1) {
            return null;
        }
        HashSet<Privilege> targetSet = new HashSet<Privilege>();
        if (this.ownPrivileges != null) {
            targetSet.addAll(this.ownPrivileges);
        }
        if (this.childWildcardPrivileges != null && authorizationhierarchy.length > partIndex + 1) {
            targetSet.addAll(this.childWildcardPrivileges);
        }
        if ((childPrivileges = this.listChildPrivilegeObjects(partIndex, authorizationhierarchy)) != null) {
            targetSet.addAll(childPrivileges);
        }
        return targetSet;
    }

    private static boolean hasChild(int partIndex, int totalLevel) {
        return totalLevel > partIndex + 1;
    }

    private static boolean hasOwn(int partIndex, int totalLevel) {
        return totalLevel >= partIndex + 1;
    }

    private Set<Privilege> listChildPrivilegeObjects(int partIndex, Authorizable ... authorizationhierarchy) {
        if (!TreePrivilegeNode.hasChild(partIndex, authorizationhierarchy.length)) {
            return null;
        }
        String childKey = TreePrivilegeNode.getResourceValue(partIndex + 1, authorizationhierarchy);
        if (StringUtils.isEmpty((String)childKey)) {
            return null;
        }
        if (TreePrivilegeNode.isResourceValueWildcard(childKey)) {
            return this.listAllChildPrivilegeObjects(partIndex, authorizationhierarchy);
        }
        if (this.childPrivileges == null) {
            return null;
        }
        TreePrivilegeNode childNode = this.childPrivileges.get(childKey);
        if (childNode == null) {
            return null;
        }
        return childNode.listPrivilegeObjects(partIndex + 1, authorizationhierarchy);
    }

    private Set<Privilege> listAllChildPrivilegeObjects(int partIndex, Authorizable ... authorizationhierarchy) {
        if (this.childPrivileges == null) {
            return null;
        }
        HashSet<Privilege> targetPrivileges = new HashSet<Privilege>();
        for (TreePrivilegeNode childNode : this.childPrivileges.values()) {
            Set<Privilege> childSet = childNode.listPrivilegeObjects(partIndex + 1, authorizationhierarchy);
            if (childSet == null || childSet.size() == 0) continue;
            targetPrivileges.addAll(childSet);
        }
        return targetPrivileges;
    }

    private boolean isOwnPrivilege(Privilege inPrivilege, int partIndex) {
        List parts = inPrivilege.getParts();
        if (!TreePrivilegeNode.hasChild(partIndex, parts.size())) {
            return true;
        }
        String partType = ((KeyValue)parts.get(partIndex + 1)).getKey();
        if ("action".equalsIgnoreCase(partType)) {
            return true;
        }
        return DBModelAuthorizable.AuthorizableType.URI.toString().equalsIgnoreCase(partType);
    }

    public static boolean isResourceValueWildcard(String resourceValue) {
        if (StringUtils.isEmpty((String)resourceValue)) {
            return false;
        }
        if ("*".equalsIgnoreCase(resourceValue)) {
            return true;
        }
        if ("+".equalsIgnoreCase(resourceValue)) {
            return true;
        }
        return "ALL".equalsIgnoreCase(resourceValue);
    }

    public static String getResourceValue(int partIndex, Authorizable[] authorizables) {
        if (authorizables == null || authorizables.length == 0) {
            return null;
        }
        if (!TreePrivilegeNode.hasOwn(partIndex, authorizables.length)) {
            return null;
        }
        Authorizable ownPart = authorizables[partIndex];
        if (ownPart == null) {
            return null;
        }
        return ownPart.getName().toLowerCase();
    }

    public static String getResourceValue(int partIndex, Privilege inPrivilege) {
        List parts = inPrivilege.getParts();
        if (parts == null) {
            return null;
        }
        if (!TreePrivilegeNode.hasOwn(partIndex, parts.size())) {
            return null;
        }
        KeyValue ownPart = (KeyValue)parts.get(partIndex);
        if (ownPart == null) {
            return null;
        }
        return ownPart.getValue().toLowerCase();
    }
}

