/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.policy.common.CommonPrivilege;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.cache.FilteredPrivilegeCache;
import org.apache.sentry.provider.cache.TreePrivilegeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreePrivilegeCache
implements FilteredPrivilegeCache {
    private final Set<String> cachedPrivileges;
    private final PrivilegeFactory privilegeFactory;
    private final Map<String, TreePrivilegeNode> cachedPrivilegeMap;
    private static final Logger LOGGER = LoggerFactory.getLogger(TreePrivilegeCache.class);

    public TreePrivilegeCache(Set<String> cachedPrivileges, PrivilegeFactory inPrivilegeFactory) {
        if (cachedPrivileges == null) {
            cachedPrivileges = new HashSet<String>();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created with privileges {}", cachedPrivileges);
        }
        this.cachedPrivileges = cachedPrivileges;
        this.privilegeFactory = inPrivilegeFactory;
        this.cachedPrivilegeMap = this.createPrivilegeMap(cachedPrivileges);
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, ActiveRoleSet roleSet) {
        return this.cachedPrivileges;
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet) {
        return this.cachedPrivileges;
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizationhierarchy) {
        Set<Privilege> privilegeObjects = this.listPrivilegeObjects(groups, users, roleSet, authorizationhierarchy);
        return privilegeObjects.stream().filter(priObj -> priObj != null).map(priObj -> priObj.toString()).collect(Collectors.toSet());
    }

    @Override
    public Set<Privilege> listPrivilegeObjects(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizationhierarchy) {
        Set<String> topResourceValues = this.getTopLevelResourceValues(authorizationhierarchy);
        HashSet<Privilege> targetSet = new HashSet<Privilege>();
        for (String topResourceValue : topResourceValues) {
            TreePrivilegeNode topNode;
            if (StringUtils.isEmpty((String)topResourceValue) || (topNode = this.cachedPrivilegeMap.get(topResourceValue)) == null) continue;
            targetSet.addAll(topNode.listPrivilegeObjects(0, authorizationhierarchy));
        }
        return targetSet;
    }

    @Override
    public void close() {
    }

    private Privilege getPrivilegeObject(String priString) {
        if (this.privilegeFactory != null) {
            return this.privilegeFactory.createPrivilege(priString);
        }
        return new CommonPrivilege(priString);
    }

    private Map<String, TreePrivilegeNode> createPrivilegeMap(Set<String> cachedPrivileges) {
        HashMap<String, TreePrivilegeNode> privilegeNodeMap = new HashMap<String, TreePrivilegeNode>();
        for (String priString : cachedPrivileges) {
            Privilege currPrivilege = this.getPrivilegeObject(priString);
            String topKey = this.getTopLevelResourceValue(currPrivilege);
            if (StringUtils.isEmpty((String)topKey)) {
                LOGGER.warn("The top level authorizable of privilege {} is null", (Object)priString);
                continue;
            }
            TreePrivilegeNode matchedNode = (TreePrivilegeNode)privilegeNodeMap.get(topKey);
            if (matchedNode == null) {
                matchedNode = new TreePrivilegeNode();
                privilegeNodeMap.put(topKey, matchedNode);
            }
            matchedNode.addPrivilege(currPrivilege, 0);
        }
        return privilegeNodeMap;
    }

    private String getTopLevelResourceValue(Privilege inPrivilege) {
        return TreePrivilegeNode.getResourceValue(0, inPrivilege);
    }

    private String getTopLevelResourceValue(Authorizable[] authorizables) {
        return TreePrivilegeNode.getResourceValue(0, authorizables);
    }

    private Set<String> getTopLevelResourceValues(Authorizable[] authorizables) {
        HashSet<String> keys = new HashSet<String>();
        keys.add("*".toLowerCase());
        keys.add("+".toLowerCase());
        keys.add("ALL".toLowerCase());
        String topKey = this.getTopLevelResourceValue(authorizables);
        if (!StringUtils.isEmpty((String)topKey)) {
            keys.add(topKey);
        }
        return keys;
    }
}

