/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.common.utils.SentryConstants;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.policy.common.CommonPrivilege;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.cache.FilteredPrivilegeCache;

public class SimpleFilteredPrivilegeCache
implements FilteredPrivilegeCache {
    private Set<String> cachedPrivileges;
    private final PrivilegeFactory privilegeFactory;
    private final Map<String, Set<String>> cachedAuthzPrivileges = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> wildCardAuthz = new HashMap<String, Set<String>>();

    public SimpleFilteredPrivilegeCache(Set<String> cachedPrivileges, PrivilegeFactory inPrivilegeFactory) {
        this.cachedPrivileges = cachedPrivileges;
        this.privilegeFactory = inPrivilegeFactory;
        for (String cachedPrivilege : cachedPrivileges) {
            Privilege privilege = this.getPrivilegeObject(cachedPrivilege);
            List authorizable = privilege.getAuthorizable();
            String authzString = this.getAuthzString(authorizable);
            this.updateWildCardAuthzMap(authorizable);
            Set<String> authzPrivileges = this.cachedAuthzPrivileges.get(authzString);
            if (authzPrivileges == null) {
                authzPrivileges = new HashSet<String>();
                this.cachedAuthzPrivileges.put(authzString, authzPrivileges);
            }
            authzPrivileges.add(cachedPrivilege);
        }
    }

    private String getAuthzString(List<KeyValue> authoriable) {
        LinkedList<KeyValue> authz = new LinkedList<KeyValue>();
        for (KeyValue auth : authoriable) {
            if (DBModelAuthorizable.AuthorizableType.URI.toString().equalsIgnoreCase(auth.getKey())) continue;
            authz.add(auth);
        }
        return SentryConstants.AUTHORIZABLE_JOINER.join(authz);
    }

    private void updateWildCardAuthzMap(List<KeyValue> authz) {
        for (KeyValue auth : authz) {
            String authKey = auth.getKey().toLowerCase();
            String authValue = auth.getValue().toLowerCase();
            Set<String> authzValue = this.wildCardAuthz.get(authKey);
            if (authzValue != null) {
                if (authzValue.contains(authValue)) continue;
                authzValue.add(authValue);
                continue;
            }
            authzValue = new HashSet<String>();
            authzValue.add(authValue);
            this.wildCardAuthz.put(authKey, authzValue);
        }
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, ActiveRoleSet roleSet) {
        if (this.cachedPrivileges == null) {
            this.cachedPrivileges = new HashSet<String>();
        }
        return this.cachedPrivileges;
    }

    @Override
    public void close() {
        if (this.cachedPrivileges != null) {
            this.cachedPrivileges = Collections.emptySet();
        }
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet) {
        if (this.cachedPrivileges == null) {
            this.cachedPrivileges = new HashSet<String>();
        }
        return this.cachedPrivileges;
    }

    @Override
    public Set<String> listPrivileges(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizationHierarchy) {
        HashSet<String> privileges = new HashSet<String>();
        Set<StringBuilder> authzKeys = this.getAuthzKeys(authorizationHierarchy);
        for (StringBuilder authzKey : authzKeys) {
            if (this.cachedAuthzPrivileges.get(authzKey.toString()) == null) continue;
            privileges.addAll((Collection<String>)this.cachedAuthzPrivileges.get(authzKey.toString()));
        }
        return privileges;
    }

    @Override
    public Set<Privilege> listPrivilegeObjects(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizationHierarchy) {
        Set<String> privilegeStrings = this.listPrivileges(groups, users, roleSet, authorizationHierarchy);
        return privilegeStrings.stream().filter(priString -> priString != null).map(priString -> this.getPrivilegeObject((String)priString)).collect(Collectors.toSet());
    }

    private Privilege getPrivilegeObject(String priString) {
        if (this.privilegeFactory != null) {
            return this.privilegeFactory.createPrivilege(priString);
        }
        return new CommonPrivilege(priString);
    }

    private Set<StringBuilder> getAuthzKeys(Authorizable ... authorizationHierarchy) {
        HashSet<StringBuilder> targets = new HashSet<StringBuilder>();
        for (Authorizable auth : authorizationHierarchy) {
            String authzType = auth.getTypeName().toLowerCase();
            String authzName = auth.getName().toLowerCase();
            if (authzType.equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.URI.toString())) continue;
            if (authzName.equals("*") || authzName.equals("+") || authzName.equals("ALL")) {
                Set<String> wildcardValues = this.wildCardAuthz.get(authzType);
                if (wildcardValues != null && wildcardValues.size() > 0) {
                    HashSet<StringBuilder> newTargets = new HashSet<StringBuilder>(targets);
                    for (StringBuilder target : targets) {
                        for (String wildcardValue : wildcardValues) {
                            newTargets.add(this.addAuthz(target, authzType, wildcardValue));
                        }
                    }
                    targets = newTargets;
                    continue;
                }
                return targets;
            }
            if (targets.isEmpty()) {
                targets.add(this.addAuthz(new StringBuilder(), authzType, authzName));
                targets.add(this.addAuthz(new StringBuilder(), authzType, "*".toLowerCase()));
                targets.add(this.addAuthz(new StringBuilder(), authzType, "ALL".toLowerCase()));
                continue;
            }
            HashSet<StringBuilder> newTargets = new HashSet<StringBuilder>(targets);
            for (StringBuilder target : targets) {
                newTargets.add(this.addAuthz(target, authzType, authzName));
                newTargets.add(this.addAuthz(target, authzType, "*".toLowerCase()));
                newTargets.add(this.addAuthz(target, authzType, "ALL".toLowerCase()));
            }
            targets = newTargets;
        }
        return targets;
    }

    private StringBuilder addAuthz(StringBuilder authorizable, String authzType, String authzName) {
        StringBuilder newAuthrizable = new StringBuilder(authorizable);
        if (newAuthrizable.length() > 0) {
            newAuthrizable.append("->");
            newAuthrizable.append(SentryConstants.KV_JOINER.join((Object)authzType, (Object)authzName, new Object[0]));
        } else {
            newAuthrizable.append(SentryConstants.KV_JOINER.join((Object)authzType, (Object)authzName, new Object[0]));
        }
        return newAuthrizable;
    }
}

