/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdFileBackendFactory;
import org.rrd4j.core.RrdNioBackend;
import org.rrd4j.core.RrdSyncThreadPool;

public class RrdNioBackendFactory
extends RrdFileBackendFactory {
    public static final int DEFAULT_SYNC_PERIOD = 300;
    private static int syncPeriod = 300;
    public static final int DEFAULT_SYNC_CORE_POOL_SIZE = 6;
    private static int syncPoolSize = 6;
    private RrdSyncThreadPool syncThreadPool;

    public static int getSyncPeriod() {
        return syncPeriod;
    }

    public static void setSyncPeriod(int syncPeriod) {
        RrdNioBackendFactory.syncPeriod = syncPeriod;
    }

    public static int getSyncPoolSize() {
        return syncPoolSize;
    }

    public static void setSyncPoolSize(int syncPoolSize) {
        RrdNioBackendFactory.syncPoolSize = syncPoolSize;
    }

    public void setSyncThreadPool(RrdSyncThreadPool syncThreadPool) {
        this.syncThreadPool = syncThreadPool;
    }

    public void setSyncThreadPool(ScheduledExecutorService syncThreadPool) {
        this.syncThreadPool = new RrdSyncThreadPool(syncThreadPool);
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        if (this.syncThreadPool == null) {
            this.syncThreadPool = DefaultSyncThreadPool.INSTANCE;
        }
        return new RrdNioBackend(path, readOnly, this.syncThreadPool, syncPeriod);
    }

    @Override
    public String getName() {
        return "NIO";
    }

    static /* synthetic */ int access$000() {
        return syncPoolSize;
    }

    private static class DefaultSyncThreadPool {
        static RrdSyncThreadPool INSTANCE = new RrdSyncThreadPool(RrdNioBackendFactory.access$000());

        private DefaultSyncThreadPool() {
        }
    }
}

