/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.kafka;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.common.ImplyMethodType;
import org.apache.sentry.core.common.Model;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.model.kafka.KafkaActionFactory;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;
import org.apache.sentry.core.model.kafka.validator.KafkaPrivilegeValidator;

public class KafkaPrivilegeModel
implements Model {
    private Map<String, ImplyMethodType> implyMethodMap = new HashMap<String, ImplyMethodType>();
    private BitFieldActionFactory bitFieldActionFactory = KafkaActionFactory.getInstance();
    private static KafkaPrivilegeModel kafkaPrivilegeModel = new KafkaPrivilegeModel();

    private KafkaPrivilegeModel() {
        this.implyMethodMap.put(KafkaAuthorizable.AuthorizableType.CLUSTER.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(KafkaAuthorizable.AuthorizableType.HOST.name().toLowerCase(), ImplyMethodType.STRING);
        this.implyMethodMap.put(KafkaAuthorizable.AuthorizableType.TOPIC.name().toLowerCase(), ImplyMethodType.STRING_CASE_SENSITIVE);
        this.implyMethodMap.put(KafkaAuthorizable.AuthorizableType.CONSUMERGROUP.name().toLowerCase(), ImplyMethodType.STRING_CASE_SENSITIVE);
        this.implyMethodMap.put(KafkaAuthorizable.AuthorizableType.TRANSACTIONALID.name().toLowerCase(), ImplyMethodType.STRING_CASE_SENSITIVE);
    }

    public Map<String, ImplyMethodType> getImplyMethodMap() {
        return this.implyMethodMap;
    }

    public BitFieldActionFactory getBitFieldActionFactory() {
        return this.bitFieldActionFactory;
    }

    public static KafkaPrivilegeModel getInstance() {
        return kafkaPrivilegeModel;
    }

    public ImmutableList<PrivilegeValidator> getPrivilegeValidators() {
        return ImmutableList.of((Object)new KafkaPrivilegeValidator());
    }
}

