/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.kafka;

import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.model.kafka.Cluster;
import org.apache.sentry.core.model.kafka.ConsumerGroup;
import org.apache.sentry.core.model.kafka.Host;
import org.apache.sentry.core.model.kafka.KafkaAuthorizable;
import org.apache.sentry.core.model.kafka.Topic;
import org.apache.sentry.core.model.kafka.TransactionalId;
import org.apache.shiro.config.ConfigurationException;

public class KafkaModelAuthorizables {
    public static KafkaAuthorizable from(KeyValue keyValue) throws ConfigurationException {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue();
        for (KafkaAuthorizable.AuthorizableType type : KafkaAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            return KafkaModelAuthorizables.from(type, name);
        }
        return null;
    }

    public static KafkaAuthorizable from(String keyValue) throws ConfigurationException {
        return KafkaModelAuthorizables.from(new KeyValue(keyValue));
    }

    public static KafkaAuthorizable from(KafkaAuthorizable.AuthorizableType type, String name) throws ConfigurationException {
        switch (type) {
            case HOST: {
                return new Host(name);
            }
            case CLUSTER: {
                if (!name.equals("kafka-cluster")) {
                    throw new ConfigurationException("Kafka's cluster resource can only have name kafka-cluster");
                }
                return new Cluster();
            }
            case TOPIC: {
                return new Topic(name);
            }
            case CONSUMERGROUP: {
                return new ConsumerGroup(name);
            }
            case TRANSACTIONALID: {
                return new TransactionalId(name);
            }
        }
        return null;
    }
}

