/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.kafka;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;

public class KafkaActionFactory
extends BitFieldActionFactory {
    private static KafkaActionFactory instance;

    private KafkaActionFactory() {
    }

    public static KafkaActionFactory getInstance() {
        if (instance == null) {
            instance = new KafkaActionFactory();
        }
        return instance;
    }

    public List<KafkaAction> getActionsByCode(int actionCode) {
        ArrayList actions = Lists.newArrayList();
        for (KafkaActionType action : KafkaActionType.getActionByCode(actionCode)) {
            actions.add(new KafkaAction(action));
        }
        return actions;
    }

    public KafkaAction getActionByName(String name) {
        if (name.equalsIgnoreCase("*")) {
            return new KafkaAction("ALL");
        }
        return KafkaActionType.hasActionType(name) ? new KafkaAction(name) : null;
    }

    public static class KafkaAction
    extends BitFieldAction {
        public KafkaAction(String name) {
            this(KafkaActionType.getActionByName(name));
        }

        public KafkaAction(KafkaActionType actionType) {
            super(actionType.name(), actionType.getCode());
        }
    }

    public static enum KafkaActionType {
        READ("read", 1),
        WRITE("write", 2),
        CREATE("create", 4),
        DELETE("delete", 8),
        ALTER("alter", 16),
        DESCRIBE("describe", 32),
        CLUSTERACTION("clusteraction", 64),
        ALTERCONFIGS("alterconfigs", 128),
        DESCRIBECONFIGS("describeconfigs", 256),
        IDEMPOTENTWRITE("idempotentwrite", 512),
        ALL("ALL", READ.getCode() | WRITE.getCode() | CREATE.getCode() | DELETE.getCode() | ALTER.getCode() | DESCRIBE.getCode() | CLUSTERACTION.getCode() | ALTERCONFIGS.getCode() | DESCRIBECONFIGS.getCode() | IDEMPOTENTWRITE.getCode());

        private String name;
        private int code;

        private KafkaActionType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        static boolean hasActionType(String name) {
            for (KafkaActionType action : KafkaActionType.values()) {
                if (!action.name.equalsIgnoreCase(name)) continue;
                return true;
            }
            return false;
        }

        static KafkaActionType getActionByName(String name) {
            for (KafkaActionType action : KafkaActionType.values()) {
                if (!action.name.equalsIgnoreCase(name)) continue;
                return action;
            }
            return null;
        }

        static List<KafkaActionType> getActionByCode(int code) {
            ArrayList actions = Lists.newArrayList();
            for (KafkaActionType action : KafkaActionType.values()) {
                if ((action.code & code) != action.code || action == ALL) continue;
                actions.add(action);
            }
            if (actions.isEmpty()) {
                return Arrays.asList(new KafkaActionType[0]);
            }
            return actions;
        }
    }
}

