/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveDecimal;

public class TimestampUtils {
    public static final BigDecimal BILLION_BIG_DECIMAL = BigDecimal.valueOf(1000000000L);

    public static double getDouble(Timestamp ts) {
        long seconds = TimestampUtils.millisToSeconds(ts.getTime());
        return (double)seconds + (double)ts.getNanos() / 1.0E9;
    }

    public static Timestamp doubleToTimestamp(double f) {
        try {
            long seconds = (long)f;
            BigDecimal bd = new BigDecimal(String.valueOf(f));
            bd = bd.subtract(new BigDecimal(seconds)).multiply(new BigDecimal(1000000000));
            int nanos = bd.intValue();
            long millis = seconds * 1000L;
            if (nanos < 0) {
                millis -= 1000L;
                nanos += 1000000000;
            }
            Timestamp t = new Timestamp(millis);
            t.setNanos(nanos);
            return t;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static Timestamp decimalToTimestamp(HiveDecimal d) {
        try {
            BigDecimal nanoInstant = d.bigDecimalValue().multiply(BILLION_BIG_DECIMAL);
            int nanos = nanoInstant.remainder(BILLION_BIG_DECIMAL).intValue();
            if (nanos < 0) {
                nanos += 1000000000;
            }
            long seconds = nanoInstant.subtract(new BigDecimal(nanos)).divide(BILLION_BIG_DECIMAL).longValue();
            Timestamp t = new Timestamp(seconds * 1000L);
            t.setNanos(nanos);
            return t;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static long millisToSeconds(long millis) {
        if (millis >= 0L) {
            return millis / 1000L;
        }
        return (millis - 999L) / 1000L;
    }
}

