/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.solr.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sentry.core.common.validator.PrivilegeValidator;
import org.apache.sentry.core.common.validator.PrivilegeValidatorContext;
import org.apache.sentry.core.model.solr.AdminOperation;
import org.apache.shiro.config.ConfigurationException;

public class SolrPrivilegeValidator
implements PrivilegeValidator {
    private static final Pattern PRIVILEGE_AUTHORIZABLE_REGEX = Pattern.compile("^(collection|admin|schema|config)\\s*=\\s*(\\S+)$", 2);
    private static final Pattern PRIVILEGE_ACTION_REGEX = Pattern.compile("^action\\s*=\\s*(query|update|\\*)$", 2);
    private String entityType;
    private String entityName;
    private String actionName;

    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        try {
            this.validate(context.getPrivilege(), false);
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException(ex.getMessage());
        }
    }

    public void validate(String privilegeStr, boolean actionRequired) {
        String[] components = privilegeStr.split("->");
        Matcher authMatcher = PRIVILEGE_AUTHORIZABLE_REGEX.matcher(components[0].trim());
        if (!authMatcher.matches()) {
            throw new IllegalArgumentException("Invalid privilege String: " + privilegeStr);
        }
        this.entityType = authMatcher.group(1).toLowerCase();
        this.entityName = authMatcher.group(2).toLowerCase();
        this.actionName = null;
        if (components.length > 1) {
            Matcher actionMactcher = PRIVILEGE_ACTION_REGEX.matcher(components[1].trim());
            if (actionMactcher.matches()) {
                this.actionName = actionMactcher.group(1).toLowerCase();
            } else {
                throw new IllegalArgumentException("Invalid privilege String: " + privilegeStr);
            }
        }
        if (actionRequired && this.actionName == null) {
            throw new IllegalArgumentException("Privilege is invalid: action required but not specified.");
        }
        this.extraPrivilegeValidation(this.entityType, this.entityName, this.actionName);
    }

    private void extraPrivilegeValidation(String entityType, String entityName, String actionName) {
        if ("admin".equals(entityType)) {
            if (!AdminOperation.ENTITY_NAMES.contains(entityName)) {
                throw new IllegalArgumentException("Invalid entity name specified for the admin entity type. Valid names are " + AdminOperation.ENTITY_NAMES);
            }
            if (AdminOperation.METRICS.getName().equals(entityName) && !"query".equals(actionName)) {
                throw new IllegalArgumentException("Invalid action specified for the metrics entity of type admin. Valid actions are [query]");
            }
        }
    }

    public String getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getActionName() {
        return this.actionName;
    }
}

