/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.solr;

import org.apache.sentry.core.common.utils.KeyValue;
import org.apache.sentry.core.model.solr.AdminOperation;
import org.apache.sentry.core.model.solr.Collection;
import org.apache.sentry.core.model.solr.Config;
import org.apache.sentry.core.model.solr.Schema;
import org.apache.sentry.core.model.solr.SolrModelAuthorizable;

public class SolrModelAuthorizables {
    private SolrModelAuthorizables() {
    }

    public static SolrModelAuthorizable from(KeyValue keyValue) {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue().toLowerCase();
        SolrModelAuthorizable result = null;
        block6: for (SolrModelAuthorizable.AuthorizableType type : SolrModelAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            switch (type) {
                case Collection: {
                    result = new Collection(name);
                    continue block6;
                }
                case Admin: {
                    result = new AdminOperation(name);
                    continue block6;
                }
                case Config: {
                    result = new Config(name);
                    continue block6;
                }
                case Schema: {
                    result = new Schema(name);
                    continue block6;
                }
            }
        }
        return result;
    }

    public static SolrModelAuthorizable from(String s) {
        return SolrModelAuthorizables.from(new KeyValue(s));
    }
}

