/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.solr;

import com.google.common.annotations.VisibleForTesting;
import org.apache.sentry.core.common.Authorizable;

public abstract class SolrModelAuthorizable
implements Authorizable {
    private final AuthorizableType type;
    private final String name;

    protected SolrModelAuthorizable(AuthorizableType type, String name) {
        this.type = type;
        this.name = name;
    }

    public String getTypeName() {
        return this.type.name();
    }

    public String getName() {
        return this.name;
    }

    @VisibleForTesting
    public AuthorizableType getAuthzType() {
        return this.type;
    }

    public String toString() {
        return String.format("%s[name=%s]", this.getTypeName(), this.name);
    }

    public static enum AuthorizableType {
        Collection,
        Field,
        Admin,
        Config,
        Schema;

    }
}

