/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.solr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;

public class SolrActionFactory
extends BitFieldActionFactory {
    private static final SolrAction[] AllActions = SolrAction.values();
    private static final SolrAction[] OneBitActions = new SolrAction[]{SolrAction.UPDATE, SolrAction.QUERY};

    public List<? extends BitFieldAction> getActionsByCode(int actionCode) {
        ArrayList actions = Lists.newArrayList();
        for (SolrAction action : OneBitActions) {
            if ((action.code & actionCode) != action.code) continue;
            actions.add(new SolrBitFieldAction(action));
        }
        return actions;
    }

    public BitFieldAction getActionByName(String name) {
        BitFieldAction val = null;
        for (SolrAction action : AllActions) {
            if (!action.name.equalsIgnoreCase(name)) continue;
            return new SolrBitFieldAction(action);
        }
        return val;
    }

    public static class SolrBitFieldAction
    extends BitFieldAction {
        public SolrBitFieldAction(SolrAction action) {
            super(action.getName(), action.getCode());
        }
    }

    public static enum SolrAction {
        UPDATE("update", 1),
        QUERY("query", 2),
        ALL("*", 3);

        private String name;
        private int code;

        private SolrAction(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }
}

