/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import java.util.ArrayList;
import java.util.List;

public class Token {
    private int index;
    private String string;

    public Token(int index, String string) {
        this.index = index;
        this.string = string;
    }

    public final int getIndex() {
        return this.index;
    }

    public final String getString() {
        return this.string;
    }

    public String toString() {
        return (this.string != null ? this.string : "(null)") + ":" + Integer.toString(this.index);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Token other = (Token)obj;
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + (this.string != null ? this.string.hashCode() : 0);
        return hash;
    }

    public static List<Token> tokenize(String input) {
        ArrayList<Token> result = new ArrayList<Token>();
        if (input == null) {
            return result;
        }
        boolean WHITESPACE = false;
        boolean WORD = true;
        int STRINGDQ = 2;
        int STRINGSQ = 3;
        int COMMENT = 4;
        int state = 0;
        int tokenIndex = -1;
        StringBuilder token = new StringBuilder("");
        block7: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) continue block7;
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        state = 1;
                        tokenIndex = i;
                        token.append(ch);
                        continue block7;
                    }
                    if (ch == '\"') {
                        state = 2;
                        tokenIndex = i;
                        continue block7;
                    }
                    if (ch == '\'') {
                        state = 3;
                        tokenIndex = i;
                        continue block7;
                    }
                    if (ch == '#') {
                        state = 4;
                        continue block7;
                    }
                    state = 1;
                    tokenIndex = i;
                    token.append(ch);
                    continue block7;
                }
                case 1: {
                    if (Character.isWhitespace(ch)) {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = 0;
                        continue block7;
                    }
                    if (Character.isLetterOrDigit(ch) || ch == '_') {
                        token.append(ch);
                        continue block7;
                    }
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            continue block7;
                        }
                        state = 2;
                        continue block7;
                    }
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            continue block7;
                        }
                        state = 3;
                        continue block7;
                    }
                    if (ch == '#') {
                        result.add(new Token(tokenIndex, token.toString()));
                        token.setLength(0);
                        state = 4;
                        continue block7;
                    }
                    token.append(ch);
                    continue block7;
                }
                case 2: {
                    if (ch == '\"') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\"') {
                            token.append('\"');
                            ++i;
                            continue block7;
                        }
                        state = 1;
                        continue block7;
                    }
                    token.append(ch);
                    continue block7;
                }
                case 3: {
                    if (ch == '\'') {
                        if (i < input.length() - 1 && input.charAt(i + 1) == '\'') {
                            token.append('\'');
                            ++i;
                            continue block7;
                        }
                        state = 1;
                        continue block7;
                    }
                    token.append(ch);
                    continue block7;
                }
                case 4: {
                    continue block7;
                }
                default: {
                    assert (false) : "Unknown state in Shell.tokenize() state machine";
                    continue block7;
                }
            }
        }
        if (state == 1 || state == 2 || state == 3) {
            result.add(new Token(tokenIndex, token.toString()));
        }
        return result;
    }

    public static String escapeString(String input) {
        StringBuilder escaped = new StringBuilder(input.length() + 10);
        escaped.append('\"');
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == '\"') {
                escaped.append("\"\"");
                continue;
            }
            escaped.append(input.charAt(i));
        }
        escaped.append('\"');
        return escaped.toString();
    }
}

