/*
 * Decompiled with CFR 0.152.
 */
package com.budhash.cliche;

import com.budhash.cliche.Command;
import com.budhash.cliche.Input;
import com.budhash.cliche.Output;
import com.budhash.cliche.OutputConversionEngine;
import com.budhash.cliche.Param;
import com.budhash.cliche.ShellManageable;
import com.budhash.cliche.TokenException;
import com.budhash.cliche.util.Strings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;

public class ConsoleIO
implements Input,
Output,
ShellManageable {
    private BufferedReader in;
    private PrintStream out;
    private PrintStream err;
    private int lastCommandOffset = 0;
    private static final String USER_PROMPT_SUFFIX = "> ";
    private static final String FILE_PROMPT_SUFFIX = "$ ";
    private InputState inputState = InputState.USER;
    private BufferedReader scriptReader = null;
    private PrintStream log = null;
    private int loopCounter = 0;

    public ConsoleIO(BufferedReader in, PrintStream out, PrintStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public ConsoleIO() {
        this(new BufferedReader(new InputStreamReader(System.in)), System.out, System.err);
    }

    @Override
    public String readCommand(List<String> path) {
        try {
            String prompt = Strings.joinStrings(path, false, '/');
            switch (this.inputState) {
                case USER: {
                    return this.readUsersCommand(prompt);
                }
                case SCRIPT: {
                    String command = this.readCommandFromScript(prompt);
                    if (command != null) {
                        return command;
                    }
                    this.closeScript();
                    return this.readUsersCommand(prompt);
                }
            }
            return this.readUsersCommand(prompt);
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private String readUsersCommand(String prompt) throws IOException {
        String completePrompt = prompt + USER_PROMPT_SUFFIX;
        this.print(completePrompt);
        this.lastCommandOffset = completePrompt.length();
        String command = this.in.readLine();
        if (this.log != null) {
            this.log.println(command);
        }
        return command;
    }

    private String readCommandFromScript(String prompt) throws IOException {
        String command = this.scriptReader.readLine();
        if (command != null) {
            String completePrompt = prompt + FILE_PROMPT_SUFFIX;
            this.print(completePrompt);
            this.lastCommandOffset = completePrompt.length();
        }
        return command;
    }

    private void closeScript() throws IOException {
        if (this.scriptReader != null) {
            this.scriptReader.close();
            this.scriptReader = null;
        }
        this.inputState = InputState.USER;
    }

    @Command(description="Reads commands from file")
    public void runScript(@Param(name="filename", description="Full file name of the script") String filename) throws FileNotFoundException {
        this.scriptReader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));
        this.inputState = InputState.SCRIPT;
    }

    @Override
    public void outputHeader(String text) {
        if (text != null) {
            this.println(text);
        }
    }

    @Override
    public void output(Object obj, OutputConversionEngine oce) {
        if (obj == null) {
            return;
        }
        if ((obj = oce.convertOutput(obj)).getClass().isArray()) {
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.output(Array.get(obj, i), 0, oce);
            }
        } else if (obj instanceof Collection) {
            for (Object elem : (Collection)obj) {
                this.output(elem, 0, oce);
            }
        } else {
            this.output(obj, 0, oce);
        }
    }

    private void output(Object obj, int indent, OutputConversionEngine oce) {
        if (obj == null) {
            return;
        }
        if (obj != null) {
            obj = oce.convertOutput(obj);
        }
        for (int i = 0; i < indent; ++i) {
            this.print("\t");
        }
        if (obj == null) {
            this.println("(null)");
        } else if (obj.getClass().isPrimitive() || obj instanceof String) {
            this.println(obj);
        } else if (obj.getClass().isArray()) {
            this.println("Array");
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                this.output(Array.get(obj, i), indent + 1, oce);
            }
        } else if (obj instanceof Collection) {
            this.println("Collection");
            for (Object elem : (Collection)obj) {
                this.output(elem, indent + 1, oce);
            }
        } else if (obj instanceof Throwable) {
            this.println(obj);
            ((Throwable)obj).printStackTrace(this.out);
        } else {
            this.println(obj);
        }
    }

    private void print(Object x) {
        this.out.print(x);
        if (this.log != null) {
            this.log.print(x);
        }
    }

    private void println(Object x) {
        this.out.println(x);
        if (this.log != null) {
            this.log.println(x);
        }
    }

    private void printErr(Object x) {
        this.err.print(x);
        if (this.log != null) {
            this.log.print(x);
        }
    }

    private void printlnErr(Object x) {
        this.err.println(x);
        if (this.log != null) {
            this.log.println(x);
        }
    }

    @Override
    public void outputException(String input, TokenException error) {
        int errIndex = error.getToken().getIndex() + this.lastCommandOffset;
        while (errIndex-- > 0) {
            this.printErr("-");
        }
        for (int i = 0; i < error.getToken().getString().length(); ++i) {
            this.printErr("^");
        }
        this.printlnErr("");
        this.printlnErr(error);
    }

    @Override
    public void outputException(Throwable e) {
        this.printlnErr(e);
        if (e.getCause() != null) {
            this.printlnErr(e.getCause());
        }
    }

    private boolean isLoggingEnabled() {
        return this.log != null;
    }

    @Override
    public void cliEnterLoop() {
        if (this.isLoggingEnabled()) {
            ++this.loopCounter;
        }
    }

    @Override
    public void cliLeaveLoop() {
        if (this.isLoggingEnabled()) {
            --this.loopCounter;
        }
        if (this.loopCounter < 0) {
            this.disableLogging();
        }
    }

    @Command(description="Sets up logging, which duplicates all subsequent output in a file")
    public void enableLogging(@Param(name="fileName", description="Name of the logfile") String filename) throws FileNotFoundException {
        this.log = new PrintStream(filename);
        this.loopCounter = 0;
    }

    @Command(description="Turns off logging")
    public String disableLogging() {
        if (this.log != null) {
            this.log.close();
            this.log = null;
            return "Logging disabled";
        }
        return "Logging is already disabled";
    }

    private static enum InputState {
        USER,
        SCRIPT;

    }
}

