/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.policy.common.CommonPrivilege;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.provider.common.TableCache;

public class CacheProvider {
    private TableCache cache;
    private volatile boolean initialized = false;

    public void initialize(TableCache cache) {
        if (this.initialized) {
            throw new IllegalStateException("CacheProvider has already been initialized, cannot be initialized twice.");
        }
        this.cache = cache;
        this.initialized = true;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("CacheProvider has not been properly initialized");
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String groupName : groups) {
            for (Map.Entry row : this.cache.getCache().row((Object)groupName).entrySet()) {
                if (!roleSet.containsRole((String)row.getKey())) continue;
                resultBuilder.addAll((Iterable)row.getValue());
            }
        }
        return resultBuilder.build();
    }

    public ImmutableSet<Privilege> getPrivilegeObjects(Set<String> groups, Set<String> users, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("CacheProvider has not been properly initialized");
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (String groupName : groups) {
            for (Map.Entry row : this.cache.getCache().row((Object)groupName).entrySet()) {
                if (!roleSet.containsRole((String)row.getKey())) continue;
                Set privilegeStrings = (Set)row.getValue();
                for (String privilegeString : privilegeStrings) {
                    resultBuilder.add((Object)this.getPrivilegeObject(privilegeString));
                }
            }
        }
        return resultBuilder.build();
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        if (!this.initialized) {
            throw new IllegalStateException("CacheProvider has not been properly initialized");
        }
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        if (groups != null) {
            for (String groupName : groups) {
                for (Map.Entry row : this.cache.getCache().row((Object)groupName).entrySet()) {
                    if (!roleSet.containsRole((String)row.getKey())) continue;
                    resultBuilder.add(row.getKey());
                }
            }
        }
        return resultBuilder.build();
    }

    private Privilege getPrivilegeObject(String priString) {
        return new CommonPrivilege(priString);
    }
}

