/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeStatusMXBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamenodeBeanMetrics
implements FSNamesystemMBean,
NameNodeMXBean,
NameNodeStatusMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(NamenodeBeanMetrics.class);
    private final Router router;
    private ObjectName fsBeanName;
    private ObjectName fsStateBeanName;
    private ObjectName nnInfoBeanName;
    private ObjectName nnStatusBeanName;

    public NamenodeBeanMetrics(Router router) {
        StandardMBean bean;
        this.router = router;
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystem", (Object)bean);
            LOG.info("Registered FSNamesystem MBean: {}", (Object)this.fsBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystem MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsStateBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
            LOG.info("Registered FSNamesystemState MBean: {}", (Object)this.fsStateBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystemState MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeMXBean.class);
            this.nnInfoBeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)bean);
            LOG.info("Registered NameNodeInfo MBean: {}", (Object)this.nnInfoBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeInfo MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeStatusMXBean.class);
            this.nnStatusBeanName = MBeans.register((String)"NameNode", (String)"NameNodeStatus", (Object)bean);
            LOG.info("Registered NameNodeStatus MBean: {}", (Object)this.nnStatusBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeStatus MBean setup", e);
        }
    }

    public void close() {
        if (this.fsStateBeanName != null) {
            MBeans.unregister((ObjectName)this.fsStateBeanName);
            this.fsStateBeanName = null;
        }
        if (this.nnInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.nnInfoBeanName);
            this.nnInfoBeanName = null;
        }
        if (this.nnStatusBeanName != null) {
            MBeans.unregister((ObjectName)this.nnStatusBeanName);
            this.nnStatusBeanName = null;
        }
    }

    private FederationMetrics getFederationMetrics() {
        return this.router.getMetrics();
    }

    @Override
    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    @Override
    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public long getUsed() {
        return this.getFederationMetrics().getUsedCapacity();
    }

    @Override
    public long getFree() {
        return this.getFederationMetrics().getRemainingCapacity();
    }

    @Override
    public long getTotal() {
        return this.getFederationMetrics().getTotalCapacity();
    }

    @Override
    public String getSafemode() {
        return "";
    }

    @Override
    public boolean isUpgradeFinalized() {
        return true;
    }

    @Override
    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        return null;
    }

    @Override
    public long getNonDfsUsedSpace() {
        return 0L;
    }

    @Override
    public float getPercentUsed() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityUsed(), (long)this.getCapacityTotal());
    }

    @Override
    public float getPercentRemaining() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityRemaining(), (long)this.getCapacityTotal());
    }

    @Override
    public long getCacheUsed() {
        return 0L;
    }

    @Override
    public long getCacheCapacity() {
        return 0L;
    }

    @Override
    public long getBlockPoolUsedSpace() {
        return 0L;
    }

    @Override
    public float getPercentBlockPoolUsed() {
        return 0.0f;
    }

    @Override
    public long getTotalBlocks() {
        return this.getFederationMetrics().getNumBlocks();
    }

    @Override
    public long getNumberOfMissingBlocks() {
        return this.getFederationMetrics().getNumOfMissingBlocks();
    }

    @Override
    @Deprecated
    public long getPendingReplicationBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingReplication();
    }

    @Override
    public long getPendingReconstructionBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingReplication();
    }

    @Override
    @Deprecated
    public long getUnderReplicatedBlocks() {
        return this.getFederationMetrics().getNumOfBlocksUnderReplicated();
    }

    @Override
    public long getLowRedundancyBlocks() {
        return this.getFederationMetrics().getNumOfBlocksUnderReplicated();
    }

    @Override
    public long getPendingDeletionBlocks() {
        return this.getFederationMetrics().getNumOfBlocksPendingDeletion();
    }

    @Override
    public long getScheduledReplicationBlocks() {
        return -1L;
    }

    @Override
    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        return 0L;
    }

    @Override
    public long getHighestPriorityLowRedundancyReplicatedBlocks() {
        return 0L;
    }

    @Override
    public long getHighestPriorityLowRedundancyECBlocks() {
        return 0L;
    }

    @Override
    public String getCorruptFiles() {
        return "N/A";
    }

    @Override
    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    @Override
    public String getLiveNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.LIVE);
    }

    @Override
    public String getDeadNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DEAD);
    }

    @Override
    public String getDecomNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DECOMMISSIONING);
    }

    private String getNodes(HdfsConstants.DatanodeReportType type) {
        HashMap info = new HashMap();
        try {
            DatanodeInfo[] datanodes;
            RouterRpcServer rpcServer = this.router.getRpcServer();
            for (DatanodeInfo node : datanodes = rpcServer.getDatanodeReport(type)) {
                HashMap<String, Object> innerinfo = new HashMap<String, Object>();
                innerinfo.put("infoAddr", node.getInfoAddr());
                innerinfo.put("infoSecureAddr", node.getInfoSecureAddr());
                innerinfo.put("xferaddr", node.getXferAddr());
                innerinfo.put("location", node.getNetworkLocation());
                innerinfo.put("lastContact", this.getLastContact(node));
                innerinfo.put("usedSpace", node.getDfsUsed());
                innerinfo.put("adminState", node.getAdminState().toString());
                innerinfo.put("nonDfsUsedSpace", node.getNonDfsUsed());
                innerinfo.put("capacity", node.getCapacity());
                innerinfo.put("numBlocks", -1);
                innerinfo.put("version", node.getSoftwareVersion() == null ? "UNKNOWN" : node.getSoftwareVersion());
                innerinfo.put("used", node.getDfsUsed());
                innerinfo.put("remaining", node.getRemaining());
                innerinfo.put("blockScheduled", -1);
                innerinfo.put("blockPoolUsed", node.getBlockPoolUsed());
                innerinfo.put("blockPoolUsedPercent", Float.valueOf(node.getBlockPoolUsedPercent()));
                innerinfo.put("volfails", -1);
                info.put(node.getHostName() + ":" + node.getXferPort(), Collections.unmodifiableMap(innerinfo));
            }
        }
        catch (StandbyException e) {
            LOG.error("Cannot get {} nodes, Router in safe mode", (Object)type);
        }
        catch (IOException e) {
            LOG.error("Cannot get " + type + " nodes", (Throwable)e);
        }
        return JSON.toString(info);
    }

    @Override
    public String getClusterId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getClusterId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch cluster ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    @Override
    public String getBlockPoolId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getBlockPoolId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch block pool ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    private Collection<String> getNamespaceInfo(Function<FederationNamespaceInfo, String> f) throws IOException {
        StateStoreService stateStore = this.router.getStateStore();
        MembershipStore membershipStore = stateStore.getRegisteredRecordStore(MembershipStore.class);
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = membershipStore.getNamespaceInfo(request);
        return response.getNamespaceInfo().stream().map(f).collect(Collectors.toSet());
    }

    @Override
    public String getNameDirStatuses() {
        return "N/A";
    }

    @Override
    public String getNodeUsage() {
        return "N/A";
    }

    @Override
    public String getNameJournalStatus() {
        return "N/A";
    }

    @Override
    public String getJournalTransactionInfo() {
        return "N/A";
    }

    @Override
    public long getNNStartedTimeInMillis() {
        return this.router.getStartTime();
    }

    @Override
    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    @Override
    public int getDistinctVersionCount() {
        return 0;
    }

    @Override
    public Map<String, Integer> getDistinctVersions() {
        return null;
    }

    @Override
    public String getFSState() {
        return "Operational";
    }

    @Override
    public long getBlocksTotal() {
        return this.getTotalBlocks();
    }

    @Override
    public long getCapacityTotal() {
        return this.getTotal();
    }

    @Override
    public long getCapacityRemaining() {
        return this.getFree();
    }

    @Override
    public long getCapacityUsed() {
        return this.getUsed();
    }

    @Override
    public long getFilesTotal() {
        return this.getFederationMetrics().getNumFiles();
    }

    @Override
    public int getTotalLoad() {
        return -1;
    }

    @Override
    public int getNumLiveDataNodes() {
        return this.router.getMetrics().getNumLiveNodes();
    }

    @Override
    public int getNumDeadDataNodes() {
        return this.router.getMetrics().getNumDeadNodes();
    }

    @Override
    public int getNumStaleDataNodes() {
        return -1;
    }

    @Override
    public int getNumDecomLiveDataNodes() {
        return this.router.getMetrics().getNumDecomLiveNodes();
    }

    @Override
    public int getNumDecomDeadDataNodes() {
        return this.router.getMetrics().getNumDecomDeadNodes();
    }

    @Override
    public int getNumDecommissioningDataNodes() {
        return this.router.getMetrics().getNumDecommissioningNodes();
    }

    @Override
    public int getNumInMaintenanceLiveDataNodes() {
        return 0;
    }

    @Override
    public int getNumInMaintenanceDeadDataNodes() {
        return 0;
    }

    @Override
    public int getNumEnteringMaintenanceDataNodes() {
        return 0;
    }

    @Override
    public int getVolumeFailuresTotal() {
        return 0;
    }

    @Override
    public long getEstimatedCapacityLostTotal() {
        return 0L;
    }

    @Override
    public String getSnapshotStats() {
        return null;
    }

    @Override
    public long getMaxObjects() {
        return 0L;
    }

    @Override
    public long getBlockDeletionStartTime() {
        return -1L;
    }

    @Override
    public int getNumStaleStorages() {
        return -1;
    }

    @Override
    public String getTopUserOpCounts() {
        return "N/A";
    }

    @Override
    public int getFsLockQueueLength() {
        return 0;
    }

    @Override
    public long getTotalSyncCount() {
        return 0L;
    }

    @Override
    public String getTotalSyncTimes() {
        return "";
    }

    private long getLastContact(DatanodeInfo node) {
        return (Time.now() - node.getLastUpdate()) / 1000L;
    }

    @Override
    public String getNNRole() {
        return HdfsServerConstants.NamenodeRole.NAMENODE.toString();
    }

    @Override
    public String getState() {
        return HAServiceProtocol.HAServiceState.ACTIVE.toString();
    }

    @Override
    public String getHostAndPort() {
        return NetUtils.getHostPortString((InetSocketAddress)this.router.getRpcServerAddress());
    }

    @Override
    public boolean isSecurityEnabled() {
        return false;
    }

    @Override
    public long getLastHATransitionTime() {
        return 0L;
    }

    @Override
    public long getBytesWithFutureGenerationStamps() {
        return 0L;
    }

    @Override
    public String getSlowPeersReport() {
        return "N/A";
    }

    @Override
    public String getSlowDisksReport() {
        return "N/A";
    }

    @Override
    public long getNumberOfSnapshottableDirs() {
        return 0L;
    }

    @Override
    public String getEnteringMaintenanceNodes() {
        return "N/A";
    }

    @Override
    public String getNameDirSize() {
        return "N/A";
    }

    @Override
    public int getNumEncryptionZones() {
        return 0;
    }

    @Override
    public String getVerifyECWithTopologyResult() {
        return null;
    }
}

