/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetrics;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.AbstractService;

public class RouterMetricsService
extends AbstractService {
    private final Router router;
    private RouterMetrics routerMetrics;
    private FederationMetrics federationMetrics;
    private NamenodeBeanMetrics nnMetrics;

    public RouterMetricsService(Router router) {
        super(RouterMetricsService.class.getName());
        this.router = router;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.routerMetrics = RouterMetrics.create(configuration);
    }

    protected void serviceStart() throws Exception {
        this.nnMetrics = new NamenodeBeanMetrics(this.router);
        this.federationMetrics = new FederationMetrics(this.router);
    }

    protected void serviceStop() throws Exception {
        if (this.federationMetrics != null) {
            this.federationMetrics.close();
        }
        if (this.nnMetrics != null) {
            this.nnMetrics.close();
        }
        if (this.routerMetrics != null) {
            this.routerMetrics.shutdown();
        }
    }

    public RouterMetrics getRouterMetrics() {
        return this.routerMetrics;
    }

    public FederationMetrics getFederationMetrics() {
        return this.federationMetrics;
    }

    public JvmMetrics getJvmMetrics() {
        if (this.routerMetrics == null) {
            return null;
        }
        return this.routerMetrics.getJvmMetrics();
    }
}

