/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.federation.metrics.FederationMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.hdfs.server.federation.router.RouterAdminServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterHttpServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetrics;
import org.apache.hadoop.hdfs.server.federation.router.RouterMetricsService;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Router
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(Router.class);
    private Configuration conf;
    private String routerId;
    private RouterRpcServer rpcServer;
    private InetSocketAddress rpcAddress;
    private RouterAdminServer adminServer;
    private InetSocketAddress adminAddress;
    private RouterHttpServer httpServer;
    private StateStoreService stateStore;
    private FileSubclusterResolver subclusterResolver;
    private ActiveNamenodeResolver namenodeResolver;
    private Collection<NamenodeHeartbeatService> namenodeHearbeatServices;
    private RouterMetricsService metrics;
    private JvmPauseMonitor pauseMonitor;

    public Router() {
        super(Router.class.getName());
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        if (this.conf.getBoolean("dfs.federation.router.store.enable", true)) {
            this.stateStore = new StateStoreService();
            this.addService((Service)this.stateStore);
        }
        this.namenodeResolver = FederationUtil.newActiveNamenodeResolver(this.conf, this.stateStore);
        if (this.namenodeResolver == null) {
            throw new IOException("Cannot find namenode resolver.");
        }
        this.subclusterResolver = FederationUtil.newFileSubclusterResolver(this.conf, this);
        if (this.subclusterResolver == null) {
            throw new IOException("Cannot find subcluster resolver");
        }
        if (this.conf.getBoolean("dfs.federation.router.rpc.enable", true)) {
            this.rpcServer = this.createRpcServer();
            this.addService((Service)this.rpcServer);
            this.setRpcServerAddress(this.rpcServer.getRpcAddress());
        }
        if (this.conf.getBoolean("dfs.federation.router.admin.enable", true)) {
            this.adminServer = this.createAdminServer();
            this.addService((Service)this.adminServer);
        }
        if (this.conf.getBoolean("dfs.federation.router.http.enable", true)) {
            this.httpServer = this.createHttpServer();
            this.addService((Service)this.httpServer);
        }
        if (this.conf.getBoolean("dfs.federation.router.heartbeat.enable", true)) {
            this.namenodeHearbeatServices = this.createNamenodeHearbeatServices();
            for (NamenodeHeartbeatService hearbeatService : this.namenodeHearbeatServices) {
                this.addService((Service)hearbeatService);
            }
            if (this.namenodeHearbeatServices.isEmpty()) {
                LOG.error("Heartbeat is enabled but there are no namenodes to monitor");
            }
        }
        if (this.conf.getBoolean("dfs.federation.router.metrics.enable", true)) {
            DefaultMetricsSystem.initialize((String)"Router");
            this.metrics = new RouterMetricsService(this);
            this.addService((Service)this.metrics);
            this.pauseMonitor = new JvmPauseMonitor();
            this.pauseMonitor.init(this.conf);
        }
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        if (this.pauseMonitor != null) {
            this.pauseMonitor.start();
            JvmMetrics jvmMetrics = this.metrics.getJvmMetrics();
            if (jvmMetrics != null) {
                jvmMetrics.setPauseMonitor(this.pauseMonitor);
            }
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.pauseMonitor != null) {
            this.pauseMonitor.stop();
        }
        super.serviceStop();
    }

    public void shutDown() {
        new Thread(){

            @Override
            public void run() {
                Router.this.stop();
            }
        }.start();
    }

    protected RouterRpcServer createRpcServer() throws IOException {
        return new RouterRpcServer(this.conf, this, this.getNamenodeResolver(), this.getSubclusterResolver());
    }

    public RouterRpcServer getRpcServer() {
        return this.rpcServer;
    }

    protected void setRpcServerAddress(InetSocketAddress address) {
        this.rpcAddress = address;
        if (this.rpcAddress != null) {
            try {
                String hostname = InetAddress.getLocalHost().getHostName();
                this.setRouterId(hostname + ":" + this.rpcAddress.getPort());
            }
            catch (UnknownHostException ex) {
                LOG.error("Cannot set unique router ID, address not resolvable {}", (Object)this.rpcAddress);
            }
        }
    }

    public InetSocketAddress getRpcServerAddress() {
        return this.rpcAddress;
    }

    protected RouterAdminServer createAdminServer() throws IOException {
        return new RouterAdminServer(this.conf, this);
    }

    protected void setAdminServerAddress(InetSocketAddress address) {
        this.adminAddress = address;
    }

    public InetSocketAddress getAdminServerAddress() {
        return this.adminAddress;
    }

    protected RouterHttpServer createHttpServer() {
        return new RouterHttpServer(this);
    }

    public InetSocketAddress getHttpServerAddress() {
        if (this.httpServer != null) {
            return this.httpServer.getHttpAddress();
        }
        return null;
    }

    protected Collection<NamenodeHeartbeatService> createNamenodeHearbeatServices() {
        String namenodes;
        NamenodeHeartbeatService localHeartbeatService;
        HashMap<String, NamenodeHeartbeatService> ret = new HashMap<String, NamenodeHeartbeatService>();
        if (this.conf.getBoolean("dfs.federation.router.monitor.localnamenode.enable", true) && (localHeartbeatService = this.createLocalNamenodeHearbeatService()) != null) {
            String nnDesc = localHeartbeatService.getNamenodeDesc();
            ret.put(nnDesc, localHeartbeatService);
        }
        if ((namenodes = this.conf.get("dfs.federation.router.monitor.namenode")) != null) {
            for (String namenode : namenodes.split(",")) {
                NamenodeHeartbeatService heartbeatService;
                String[] namenodeSplit = namenode.split("\\.");
                String nsId = null;
                String nnId = null;
                if (namenodeSplit.length == 2) {
                    nsId = namenodeSplit[0];
                    nnId = namenodeSplit[1];
                } else if (namenodeSplit.length == 1) {
                    nsId = namenode;
                } else {
                    LOG.error("Wrong Namenode to monitor: {}", (Object)namenode);
                }
                if (nsId == null || (heartbeatService = this.createNamenodeHearbeatService(nsId, nnId)) == null) continue;
                ret.put(heartbeatService.getNamenodeDesc(), heartbeatService);
            }
        }
        return ret.values();
    }

    protected NamenodeHeartbeatService createLocalNamenodeHearbeatService() {
        String nsId = DFSUtil.getNamenodeNameServiceId(this.conf);
        String nnId = null;
        if (HAUtil.isHAEnabled(this.conf, nsId) && (nnId = HAUtil.getNameNodeId(this.conf, nsId)) == null) {
            LOG.error("Cannot find namenode id for local {}", (Object)nsId);
        }
        return this.createNamenodeHearbeatService(nsId, nnId);
    }

    protected NamenodeHeartbeatService createNamenodeHearbeatService(String nsId, String nnId) {
        LOG.info("Creating heartbeat service for Namenode {} in {}", (Object)nnId, (Object)nsId);
        NamenodeHeartbeatService ret = new NamenodeHeartbeatService(this.namenodeResolver, nsId, nnId);
        return ret;
    }

    public StateStoreService getStateStore() {
        return this.stateStore;
    }

    public RouterMetrics getRouterMetrics() {
        if (this.metrics != null) {
            return this.metrics.getRouterMetrics();
        }
        return null;
    }

    public FederationMetrics getMetrics() {
        if (this.metrics != null) {
            return this.metrics.getFederationMetrics();
        }
        return null;
    }

    public FileSubclusterResolver getSubclusterResolver() {
        return this.subclusterResolver;
    }

    public ActiveNamenodeResolver getNamenodeResolver() {
        return this.namenodeResolver;
    }

    public String getRouterId() {
        return this.routerId;
    }

    public void setRouterId(String id) {
        this.routerId = id;
        if (this.stateStore != null) {
            this.stateStore.setIdentifier(this.routerId);
        }
        if (this.namenodeResolver != null) {
            this.namenodeResolver.setRouterId(this.routerId);
        }
    }
}

