/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.util;

import com.google.common.base.Splitter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.api.common.ApiConstants;
import org.apache.sentry.api.service.thrift.TSentryGrantOption;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryRole;
import org.apache.sentry.binding.hive.SentryOnFailureHook;
import org.apache.sentry.binding.hive.SentryOnFailureHookContext;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryAuthorizerUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SentryAuthorizerUtil.class);
    public static String UNKONWN_GRANTOR = "--";

    public static AccessURI parseURI(String uri, boolean isLocal) throws URISyntaxException {
        HiveConf conf = SessionState.get().getConf();
        String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
        return new AccessURI(PathUtils.parseURI((String)warehouseDir, (String)uri, (boolean)isLocal));
    }

    public static List<List<DBModelAuthorizable>> getAuthzHierarchy(Server server, HivePrivilegeObject privilege) {
        ArrayList<Object> baseHierarchy = new ArrayList<Object>();
        ArrayList<List<DBModelAuthorizable>> objectHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        boolean isLocal = false;
        if (privilege.getType() != null) {
            switch (privilege.getType()) {
                case GLOBAL: {
                    baseHierarchy.add(new Server(privilege.getObjectName()));
                    objectHierarchy.add(baseHierarchy);
                    break;
                }
                case DATABASE: {
                    baseHierarchy.add(server);
                    baseHierarchy.add(new Database(privilege.getDbname()));
                    objectHierarchy.add(baseHierarchy);
                    break;
                }
                case TABLE_OR_VIEW: {
                    baseHierarchy.add(server);
                    baseHierarchy.add(new Database(privilege.getDbname()));
                    baseHierarchy.add(new Table(privilege.getObjectName()));
                    if (privilege.getColumns() != null) {
                        for (String columnName : privilege.getColumns()) {
                            ArrayList<Column> columnHierarchy = new ArrayList<Column>(baseHierarchy);
                            columnHierarchy.add(new Column(columnName));
                            objectHierarchy.add(columnHierarchy);
                        }
                        break;
                    }
                    objectHierarchy.add(baseHierarchy);
                    break;
                }
                case LOCAL_URI: {
                    isLocal = true;
                }
                case DFS_URI: {
                    if (privilege.getObjectName() == null) break;
                    try {
                        baseHierarchy.add(server);
                        baseHierarchy.add(SentryAuthorizerUtil.parseURI(privilege.getObjectName(), isLocal));
                        objectHierarchy.add(baseHierarchy);
                        break;
                    }
                    catch (Exception e) {
                        throw new AuthorizationException("Failed to get File URI", (Throwable)e);
                    }
                }
                case FUNCTION: 
                case PARTITION: 
                case COLUMN: 
                case COMMAND_PARAMS: {
                    break;
                }
            }
        }
        return objectHierarchy;
    }

    public static Set<List<DBModelAuthorizable>> convert2SentryPrivilegeList(Server server, List<HivePrivilegeObject> privilges) {
        HashSet<List<DBModelAuthorizable>> hierarchyList = new HashSet<List<DBModelAuthorizable>>();
        if (privilges != null && !privilges.isEmpty()) {
            for (HivePrivilegeObject p : privilges) {
                hierarchyList.addAll(SentryAuthorizerUtil.getAuthzHierarchy(server, p));
            }
        }
        return hierarchyList;
    }

    public static HiveOperation convert2HiveOperation(String typeName) {
        try {
            return HiveOperation.valueOf((String)typeName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convert2SentryAction(HivePrivilege hivePrivilege) {
        if (PrivilegeType.ALL.name().equals(hivePrivilege.getName())) {
            return "*";
        }
        return hivePrivilege.getName();
    }

    public static HivePrivilege convert2HivePrivilege(String action) {
        return new HivePrivilege(action, null);
    }

    public static List<String> convert2RoleList(Set<TSentryRole> roleSet) {
        ArrayList<String> roles = new ArrayList<String>();
        if (roleSet != null && !roleSet.isEmpty()) {
            for (TSentryRole tRole : roleSet) {
                roles.add(tRole.getRoleName());
            }
        }
        return roles;
    }

    public static HivePrivilegeInfo convert2HivePrivilegeInfo(TSentryPrivilege tPrivilege, HivePrincipal principal) {
        HivePrivilege hivePrivilege = SentryAuthorizerUtil.convert2HivePrivilege(tPrivilege.getAction());
        HivePrivilegeObject hivePrivilegeObject = SentryAuthorizerUtil.convert2HivePrivilegeObject(tPrivilege);
        HivePrincipal grantor = new HivePrincipal(UNKONWN_GRANTOR, HivePrincipal.HivePrincipalType.ROLE);
        boolean grantOption = tPrivilege.getGrantOption().equals((Object)TSentryGrantOption.TRUE);
        int hiveCreateTime = (int)TimeUnit.SECONDS.convert(tPrivilege.getCreateTime(), TimeUnit.MILLISECONDS);
        return new HivePrivilegeInfo(principal, hivePrivilege, hivePrivilegeObject, grantor, grantOption, hiveCreateTime);
    }

    public static HivePrivilegeObject convert2HivePrivilegeObject(TSentryPrivilege tSentryPrivilege) {
        HivePrivilegeObject privilege = null;
        switch (ApiConstants.PrivilegeScope.valueOf((String)tSentryPrivilege.getPrivilegeScope())) {
            case SERVER: {
                privilege = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.GLOBAL, "*", null);
                break;
            }
            case DATABASE: {
                privilege = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, tSentryPrivilege.getDbName(), null);
                break;
            }
            case TABLE: {
                privilege = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, tSentryPrivilege.getDbName(), tSentryPrivilege.getTableName());
                break;
            }
            case COLUMN: {
                privilege = new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.COLUMN, tSentryPrivilege.getDbName(), tSentryPrivilege.getTableName(), null, tSentryPrivilege.getColumnName());
                break;
            }
            case URI: {
                String uriString = tSentryPrivilege.getURI();
                try {
                    uriString = uriString.replace("'", "").replace("\"", "");
                    HivePrivilegeObject.HivePrivilegeObjectType type = SentryAuthorizerUtil.isLocalUri(uriString) ? HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI : HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI;
                    privilege = new HivePrivilegeObject(type, uriString, null);
                }
                catch (URISyntaxException e1) {
                    throw new RuntimeException(uriString + "is not a URI");
                }
            }
            default: {
                LOG.warn("Unknown PrivilegeScope: " + ApiConstants.PrivilegeScope.valueOf((String)tSentryPrivilege.getPrivilegeScope()));
            }
        }
        return privilege;
    }

    public static boolean isLocalUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        Path uriPath = new Path(uri);
        return uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("file") || uri.getScheme() == null && uriPath.isAbsolute();
    }

    public static HiveRoleGrant convert2HiveRoleGrant(TSentryRole role) {
        HiveRoleGrant hiveRoleGrant = new HiveRoleGrant();
        hiveRoleGrant.setRoleName(role.getRoleName());
        hiveRoleGrant.setPrincipalName(role.getRoleName());
        hiveRoleGrant.setPrincipalType(PrincipalType.ROLE.name());
        hiveRoleGrant.setGrantOption(false);
        hiveRoleGrant.setGrantor(role.getGrantorPrincipal());
        hiveRoleGrant.setGrantorType(PrincipalType.USER.name());
        return hiveRoleGrant;
    }

    public static void executeOnFailureHooks(SentryOnFailureHookContext hookCtx, Configuration conf) {
        String csHooks = conf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), "").trim();
        try {
            for (Hook aofh : SentryAuthorizerUtil.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookCtx);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    public static List<Hook> getHooks(String csHooks) throws Exception {
        return SentryAuthorizerUtil.getHooks(csHooks, Hook.class);
    }

    public static <T extends Hook> List<T> getHooks(String csHooks, Class<T> clazz) throws Exception {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (csHooks.isEmpty()) {
            return hooks;
        }
        for (String hookClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)csHooks)) {
            try {
                Hook hook = (Hook)Class.forName(hookClass, true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error(hookClass + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }
}

