/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.AddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.AlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.sentry.api.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.metastore.SentryHmsEvent;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentrySyncHMSNotificationsPostEventListener
extends MetaStoreEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentrySyncHMSNotificationsPostEventListener.class);
    private final HiveAuthzConf authzConf;
    private final String serverName;
    private final AtomicLong latestProcessedId = new AtomicLong(0L);
    private SentryPolicyServiceClient serviceClient;

    public SentrySyncHMSNotificationsPostEventListener(Configuration config) {
        super(config);
        if (!(config instanceof HiveConf)) {
            String error = "Could not initialize Plugin - Configuration is not an instanceof HiveConf";
            LOGGER.error(error);
            throw new RuntimeException(error);
        }
        this.authzConf = HiveAuthzConf.getAuthzConf((HiveConf)((HiveConf)config));
        this.serverName = this.getServerName();
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        if (this.failedEvent((ListenerEvent)tableEvent, EventMessage.EventType.CREATE_TABLE)) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, tableEvent);
        this.notifyHmsEvent(event);
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (this.failedEvent((ListenerEvent)tableEvent, EventMessage.EventType.DROP_TABLE)) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, tableEvent);
        this.notifyHmsEvent(event);
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        if (tableEvent == null) {
            return;
        }
        Table oldTable = tableEvent.getOldTable();
        Table newTable = tableEvent.getNewTable();
        if (oldTable == null) {
            return;
        }
        if (newTable == null) {
            return;
        }
        if (this.failedEvent((ListenerEvent)tableEvent, EventMessage.EventType.ALTER_TABLE)) {
            return;
        }
        if (StringUtils.equals((String)oldTable.getOwner(), (String)newTable.getOwner()) && StringUtils.equalsIgnoreCase((String)oldTable.getDbName(), (String)newTable.getDbName()) && StringUtils.equalsIgnoreCase((String)oldTable.getTableName(), (String)newTable.getTableName())) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, tableEvent);
        this.notifyHmsEvent(event);
    }

    public void onAddPartition(AddPartitionEvent partitionEvent) throws MetaException {
    }

    public void onDropPartition(DropPartitionEvent partitionEvent) throws MetaException {
    }

    public void onAlterPartition(AlterPartitionEvent partitionEvent) throws MetaException {
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        if (this.failedEvent((ListenerEvent)dbEvent, EventMessage.EventType.CREATE_DATABASE)) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, dbEvent);
        this.notifyHmsEvent(event);
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        if (this.failedEvent((ListenerEvent)dbEvent, EventMessage.EventType.DROP_DATABASE)) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, dbEvent);
        this.notifyHmsEvent(event);
    }

    public void onAlterDatabase(AlterDatabaseEvent dbEvent) throws MetaException {
        if (this.failedEvent((ListenerEvent)dbEvent, EventMessage.EventType.ALTER_DATABASE)) {
            return;
        }
        SentryHmsEvent event = new SentryHmsEvent(this.serverName, dbEvent);
        this.notifyHmsEvent(event);
    }

    private void notifyHmsEvent(SentryHmsEvent event) {
        if (event.isMetastoreTransactionActive().booleanValue()) {
            return;
        }
        if (!this.shouldSyncEvent(event)) {
            event.setEventId(0L);
        }
        try (SentryPolicyServiceClient sentryClient = this.getSentryServiceClient();){
            LOGGER.debug("Notifying sentry about Notification for {} (id: {})", (Object)event.getEventType(), (Object)event.getEventId());
            long sentryLatestProcessedId = sentryClient.notifyHmsEvent(this.getUserName(), event.getEventId(), event.getEventType().toString(), event.getOwnerType(), event.getOwnerName(), event.getAuthorizable());
            LOGGER.debug("Finished Notifying sentry about Notification for {} (id: {})", (Object)event.getEventType(), (Object)event.getEventId());
            LOGGER.debug("Latest processed event ID returned by the Sentry server: {}", (Object)sentryLatestProcessedId);
            this.updateProcessedId(sentryLatestProcessedId);
        }
        catch (Exception e) {
            LOGGER.error("Encountered failure while notifying notification for {} (id: {})", new Object[]{event.getEventType(), event.getEventId(), e});
        }
    }

    private void updateProcessedId(long eventId) {
        long oldVal = this.latestProcessedId.get();
        if (eventId > oldVal) {
            this.latestProcessedId.compareAndSet(oldVal, eventId);
        }
    }

    @VisibleForTesting
    void setSentryServiceClient(SentryPolicyServiceClient serviceClient) {
        this.serviceClient = serviceClient;
    }

    private SentryPolicyServiceClient getSentryServiceClient() throws MetaException {
        if (this.serviceClient != null) {
            return this.serviceClient;
        }
        try {
            return SentryServiceClientFactory.create((Configuration)this.authzConf);
        }
        catch (Exception e) {
            throw new MetaException("Failed to connect to Sentry service " + e.getMessage());
        }
    }

    private boolean failedEvent(ListenerEvent event, EventMessage.EventType eventType) {
        if (!event.getStatus()) {
            LOGGER.debug("Skip HMS synchronization request with the Sentry server for {} {} since the operation failed. \n", (Object)eventType.toString(), (Object)event);
            return true;
        }
        return false;
    }

    private boolean shouldSyncEvent(SentryHmsEvent event) {
        if (event.getEventId() < 0L) {
            return false;
        }
        return event.getEventId() > this.latestProcessedId.get();
    }

    private String getServerName() {
        String serverName = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar());
        if (!StringUtils.isEmpty((String)serverName)) {
            return serverName;
        }
        return this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME_DEPRECATED.getVar(), HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME_DEPRECATED.getDefault());
    }

    private String getUserName() throws MetaException {
        try {
            return Utils.getUGI().getShortUserName();
        }
        catch (LoginException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to get username " + e.getMessage());
        }
    }
}

