/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.MetastoreAuthzObjectFilter;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.metastore.HiveAuthzBindingFactory;
import org.apache.sentry.binding.metastore.MetastoreAuthzBindingBase;

public class SentryMetaStoreFilterHook
implements MetaStoreFilterHook {
    protected static final Log LOG = LogFactory.getLog(SentryMetaStoreFilterHook.class);
    private final HiveConf hiveConf;
    private HiveAuthzBindingFactory authzBindingFactory;
    private HiveAuthzConf authzConf;
    private Set<String> serviceUsers;

    public SentryMetaStoreFilterHook(HiveConf hiveConf) {
        this(hiveConf, HiveAuthzConf.getAuthzConf((HiveConf)hiveConf), new HiveAuthzBindingFactory(){

            @Override
            public HiveAuthzBinding fromMetaStoreConf(HiveConf hiveConf, HiveAuthzConf authzConf) throws Exception {
                return new HiveAuthzBinding(HiveAuthzBinding.HiveHook.HiveMetaStore, hiveConf, authzConf);
            }

            @Override
            public String getUserName() {
                try {
                    return Utils.getUGI().getShortUserName();
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to get the HMS username: " + e.getMessage());
                }
            }
        });
    }

    public SentryMetaStoreFilterHook(HiveConf hiveConf, HiveAuthzConf authzConf, HiveAuthzBindingFactory authzBindingFactory) {
        this.hiveConf = hiveConf;
        this.authzConf = authzConf;
        this.authzBindingFactory = authzBindingFactory;
        this.serviceUsers = Sets.newHashSet((Iterable)authzConf.getTrimmedStringCollection(HiveAuthzConf.AuthzConfVars.AUTHZ_METASTORE_SERVICE_USERS.getVar()));
        LOG.info((Object)("SentryMetaStoreFilterHook initialized with service users: " + this.serviceUsers));
    }

    public List<String> filterDatabases(List<String> dbList) {
        return this.filterDb(dbList);
    }

    public Database filterDatabase(Database dataBase) throws NoSuchObjectException {
        String name = dataBase.getName();
        if (this.filterDb(Collections.singletonList(name)).isEmpty()) {
            throw new NoSuchObjectException(String.format("Database %s does not exist", name));
        }
        return dataBase;
    }

    public List<String> filterTableNames(String dbName, List<String> tableList) {
        return this.filterTab(dbName, tableList);
    }

    public Table filterTable(Table table) throws NoSuchObjectException {
        String tableName;
        String dbName = table.getDbName();
        if (this.filterTab(dbName, Collections.singletonList(tableName = table.getTableName())).isEmpty()) {
            throw new NoSuchObjectException(String.format("Table %s.%s does not exist", dbName, tableName));
        }
        return table;
    }

    public List<Table> filterTables(List<Table> tableList) {
        return this.filterTab(tableList);
    }

    public List<Partition> filterPartitions(List<Partition> partitionList) {
        return partitionList;
    }

    public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) {
        return partitionSpecList;
    }

    public Partition filterPartition(Partition partition) throws NoSuchObjectException {
        return partition;
    }

    public List<String> filterPartitionNames(String dbName, String tblName, List<String> partitionNames) {
        return partitionNames;
    }

    public Index filterIndex(Index index) throws NoSuchObjectException {
        return index;
    }

    public List<String> filterIndexNames(String dbName, String tblName, List<String> indexList) {
        return indexList;
    }

    public List<Index> filterIndexes(List<Index> indexeList) {
        return indexeList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> filterDb(List<String> dbList) {
        String userName = this.authzBindingFactory.getUserName();
        if (!this.needsAuthorization(userName)) {
            return dbList;
        }
        try (HiveAuthzBinding authzBinding = this.getHiveAuthzBinding(userName);){
            MetastoreAuthzObjectFilter<String> filter = new MetastoreAuthzObjectFilter<String>(authzBinding, new MetastoreAuthzObjectFilter.ObjectExtractor<String>(){

                @Override
                public String getDatabaseName(String o) {
                    return o;
                }

                @Override
                public String getTableName(String s) {
                    return null;
                }
            });
            List<String> list = filter.filterDatabases(this.authzBindingFactory.getUserName(), dbList);
            return list;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting DB list ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> filterTab(final String dbName, List<String> tabList) {
        String userName = this.authzBindingFactory.getUserName();
        if (!this.needsAuthorization(userName)) {
            return tabList;
        }
        try (HiveAuthzBinding authzBinding = this.getHiveAuthzBinding(userName);){
            MetastoreAuthzObjectFilter<String> filter = new MetastoreAuthzObjectFilter<String>(authzBinding, new MetastoreAuthzObjectFilter.ObjectExtractor<String>(){

                @Override
                public String getDatabaseName(String o) {
                    return dbName;
                }

                @Override
                public String getTableName(String o) {
                    return o;
                }
            });
            List<String> list = filter.filterTables(this.authzBindingFactory.getUserName(), tabList);
            return list;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting Table list ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Table> filterTab(List<Table> tabList) {
        String userName = this.authzBindingFactory.getUserName();
        if (!this.needsAuthorization(userName)) {
            return tabList;
        }
        try (HiveAuthzBinding authzBinding = this.getHiveAuthzBinding(userName);){
            MetastoreAuthzObjectFilter<Table> filter = new MetastoreAuthzObjectFilter<Table>(authzBinding, new MetastoreAuthzObjectFilter.ObjectExtractor<Table>(){

                @Override
                public String getDatabaseName(Table o) {
                    return o != null ? o.getDbName() : null;
                }

                @Override
                public String getTableName(Table o) {
                    return o != null ? o.getTableName() : null;
                }
            });
            List<Table> list = filter.filterTables(this.authzBindingFactory.getUserName(), tabList);
            return list;
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting Table list ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private HiveAuthzBinding getHiveAuthzBinding(String userName) throws MetaException {
        try {
            HiveAuthzBinding hiveAuthzBindingNoCache = this.authzBindingFactory.fromMetaStoreConf(this.hiveConf, this.authzConf);
            return MetastoreAuthzBindingBase.getHiveBindingWithPrivilegeCache(hiveAuthzBindingNoCache, userName);
        }
        catch (Exception e) {
            throw new MetaException("The Sentry/Hive authz binding could not be created: " + e.getMessage());
        }
    }

    private boolean needsAuthorization(String username) {
        return !this.serviceUsers.contains(username);
    }
}

