/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.sentry.binding.hive.authz.DefaultSentryAccessController;
import org.apache.sentry.binding.hive.authz.DefaultSentryValidator;
import org.apache.sentry.binding.hive.authz.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.authz.SentryHiveAuthorizerImpl;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;

public class SentryHiveAuthorizerFactory
implements HiveAuthorizerFactory {
    public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext ctx) throws HiveAuthzPluginException {
        DefaultSentryValidator authValidator;
        DefaultSentryAccessController accessController;
        HiveAuthzConf authzConf = HiveAuthzBindingHookBase.loadAuthzConf(conf);
        HiveAuthzSessionContext sessionContext = this.applyTestSettings(ctx, conf);
        try {
            accessController = new DefaultSentryAccessController(conf, authzConf, hiveAuthenticator, sessionContext);
            authValidator = new DefaultSentryValidator(conf, authzConf, hiveAuthenticator);
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException((Throwable)e);
        }
        return new SentryHiveAuthorizerImpl(accessController, authValidator);
    }

    private HiveAuthzSessionContext applyTestSettings(HiveAuthzSessionContext ctx, HiveConf conf) {
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_AUTHORIZATION_SQLSTD_HS2_MODE) && ctx.getClientType() == HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI) {
            HiveAuthzSessionContext.Builder ctxBuilder = new HiveAuthzSessionContext.Builder(ctx);
            ctxBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2);
            return ctxBuilder.build();
        }
        return ctx;
    }
}

