/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.sentry.api.service.thrift.SentryObjectPrivileges;
import org.apache.sentry.api.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.api.service.thrift.TSentryAuthorizable;
import org.apache.sentry.api.service.thrift.TSentryPrivilege;
import org.apache.sentry.api.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.api.service.thrift.TSentryRole;
import org.apache.sentry.binding.hive.SentryOnFailureHookContext;
import org.apache.sentry.binding.hive.SentryOnFailureHookContextImpl;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.SentryHiveAccessController;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.binding.util.SentryAuthorizerUtil;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.exception.SentryAccessDeniedException;
import org.apache.sentry.core.common.exception.SentryNoSuchObjectException;
import org.apache.sentry.core.common.exception.SentryUserException;
import org.apache.sentry.core.model.db.AccessConstants;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSentryAccessController
extends SentryHiveAccessController {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultSentryAccessController.class);
    public static final String REQUIRED_AUTHZ_SERVER_NAME = "Config " + HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar() + " is required";
    private HiveAuthenticationProvider authenticator;
    private String serverName;
    private HiveConf conf;
    private HiveAuthzConf authzConf;
    private HiveAuthzSessionContext ctx;
    private HiveAuthzBinding.HiveHook hiveHook;
    private HiveAuthzBinding hiveAuthzBinding;
    protected SentryPolicyServiceClient sentryClient;

    public DefaultSentryAccessController(HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) throws Exception {
        this.initilize(conf, authzConf, authenticator, ctx);
        this.hiveHook = HiveAuthzBinding.HiveHook.HiveServer2;
    }

    public DefaultSentryAccessController(HiveAuthzBinding.HiveHook hiveHook, HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) throws Exception {
        this.initilize(conf, authzConf, authenticator, ctx);
        this.hiveHook = hiveHook;
    }

    protected void initilize(HiveConf conf, HiveAuthzConf authzConf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) throws Exception {
        Preconditions.checkNotNull((Object)conf, (Object)"HiveConf cannot be null");
        Preconditions.checkNotNull((Object)authzConf, (Object)"HiveAuthzConf cannot be null");
        Preconditions.checkNotNull((Object)authenticator, (Object)"Hive authenticator provider cannot be null");
        Preconditions.checkNotNull((Object)ctx, (Object)"HiveAuthzSessionContext cannot be null");
        this.conf = conf;
        this.authzConf = authzConf;
        this.authenticator = authenticator;
        this.ctx = ctx;
        this.serverName = (String)Preconditions.checkNotNull((Object)authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()), (Object)REQUIRED_AUTHZ_SERVER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        if (AccessConstants.RESERVED_ROLE_NAMES.contains((Object)roleName.toUpperCase())) {
            String msg = "Roles cannot be one of the reserved roles: " + AccessConstants.RESERVED_ROLE_NAMES;
            throw new HiveAccessControlException(msg);
        }
        try {
            this.sentryClient = this.getSentryClient();
            this.sentryClient.createRole(this.authenticator.getUserName(), roleName);
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.CREATEROLE;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Sentry failed to create role: " + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        if (AccessConstants.RESERVED_ROLE_NAMES.contains((Object)roleName.toUpperCase())) {
            String msg = "Roles cannot be one of the reserved roles: " + AccessConstants.RESERVED_ROLE_NAMES;
            throw new HiveAccessControlException(msg);
        }
        try {
            this.sentryClient = this.getSentryClient();
            this.sentryClient.dropRole(this.authenticator.getUserName(), roleName);
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.DROPROLE;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Sentry failed to drop role: " + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRoles() throws HiveAccessControlException, HiveAuthzPluginException {
        ArrayList<String> roles = new ArrayList();
        try {
            this.sentryClient = this.getSentryClient();
            roles = this.convert2RoleList(this.sentryClient.listAllRoles(this.authenticator.getUserName()));
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.SHOW_ROLES;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient listRoles: " + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
        return roles;
    }

    @Override
    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        this.grantOrRevokePrivlegeOnRole(hivePrincipals, hivePrivileges, hivePrivObject, grantOption, true);
    }

    @Override
    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        this.grantOrRevokePrivlegeOnRole(hivePrincipals, hivePrivileges, hivePrivObject, grantOption, false);
    }

    @Override
    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        this.grantOrRevokeRoleOnGroup(hivePrincipals, roles, grantorPrinc, true);
    }

    @Override
    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        this.grantOrRevokeRoleOnGroup(hivePrincipals, roles, grantorPrinc, false);
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        if (principal.getName().isEmpty()) {
            return this.showPriviliegesForObject(privObj);
        }
        return this.showPrivilegesByPrincipal(principal, privObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HivePrivilegeInfo> showPrivilegesByPrincipal(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        if (principal.getType() != HivePrincipal.HivePrincipalType.ROLE && principal.getType() != HivePrincipal.HivePrincipalType.USER) {
            String msg = "Sentry does not allow privileges to be shown for: " + principal.getType();
            throw new HiveAuthzPluginException(msg);
        }
        ArrayList<HivePrivilegeInfo> infoList = new ArrayList<HivePrivilegeInfo>();
        try {
            this.sentryClient = this.getSentryClient();
            List<List<DBModelAuthorizable>> authorizables = SentryAuthorizerUtil.getAuthzHierarchy(new Server(this.serverName), privObj);
            HashSet tPrivilges = new HashSet();
            if (authorizables != null && !authorizables.isEmpty()) {
                for (List<DBModelAuthorizable> authorizable : authorizables) {
                    switch (principal.getType()) {
                        case ROLE: {
                            tPrivilges.addAll(this.sentryClient.listPrivilegesByRoleName(this.authenticator.getUserName(), principal.getName(), authorizable));
                            break;
                        }
                        case USER: {
                            try {
                                tPrivilges.addAll(this.sentryClient.listPrivilegesByUserName(this.authenticator.getUserName(), principal.getName(), authorizable));
                                break;
                            }
                            catch (SentryNoSuchObjectException e) {
                                LOG.info("User {} requested does not exist in Sentry", (Object)this.authenticator.getUserName());
                            }
                        }
                    }
                }
            } else {
                switch (principal.getType()) {
                    case ROLE: {
                        tPrivilges.addAll(this.sentryClient.listPrivilegesByRoleName(this.authenticator.getUserName(), principal.getName(), null));
                        break;
                    }
                    case USER: {
                        try {
                            tPrivilges.addAll(this.sentryClient.listPrivilegesByUserName(this.authenticator.getUserName(), principal.getName(), null));
                            break;
                        }
                        catch (SentryNoSuchObjectException e) {
                            LOG.info("User {} requested does not exist in Sentry", (Object)this.authenticator.getUserName());
                        }
                    }
                }
            }
            if (tPrivilges != null && !tPrivilges.isEmpty()) {
                for (TSentryPrivilege privilege : tPrivilges) {
                    infoList.add(SentryAuthorizerUtil.convert2HivePrivilegeInfo(privilege, principal));
                }
            }
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.SHOW_GRANT;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient listPrivilegesByRoleName: " + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
        return infoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HivePrivilegeInfo> showPriviliegesForObject(HivePrivilegeObject privObj) throws HiveAuthzPluginException, HiveAccessControlException {
        ArrayList<HivePrivilegeInfo> infoList = new ArrayList<HivePrivilegeInfo>();
        if (privObj == null) {
            String msg = "Sentry does not allow privileges to be shown for: unspecified object name";
            throw new HiveAuthzPluginException(msg);
        }
        try {
            this.sentryClient = this.getSentryClient();
            HashSet authorizableSet = Sets.newHashSet(SentryAuthorizerUtil.getAuthzHierarchy(new Server(this.serverName), privObj));
            Set<String> users = Collections.singleton(this.authenticator.getUserName());
            SentryObjectPrivileges sentryObjectPrivileges = null;
            if (authorizableSet == null || authorizableSet.isEmpty()) {
                String msg = "Sentry does not allow privileges to be shown for: object name [" + privObj.getObjectName() + "] does not exist";
                throw new HiveAuthzPluginException(msg);
            }
            this.hiveAuthzBinding = new HiveAuthzBinding(this.hiveHook, this.conf, this.authzConf);
            sentryObjectPrivileges = this.sentryClient.getAllPrivilegesbyAuthorizable(this.authenticator.getUserName(), (Set)authorizableSet, null, users, this.hiveAuthzBinding.getActiveRoleSet());
            Map rolePrivilegesMap = sentryObjectPrivileges.getPrivilegesForRoles();
            this.generateHivePrincipalInfo(infoList, rolePrivilegesMap, HivePrincipal.HivePrincipalType.ROLE);
            Map userPrivilegesMap = sentryObjectPrivileges.getPrivilegesForUsers();
            this.generateHivePrincipalInfo(infoList, userPrivilegesMap, HivePrincipal.HivePrincipalType.USER);
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.SHOW_GRANT;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient listPrivilegesbyAuthorizable: " + (Object)((Object)e);
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Error when sentryClient listPrivilegesbyAuthorizable: " + e;
            this.executeOnErrorHooks(msg, e);
        }
        finally {
            this.closeClient();
        }
        return infoList;
    }

    private void generateHivePrincipalInfo(List<HivePrivilegeInfo> infoList, Map<TSentryAuthorizable, TSentryPrivilegeMap> privilegesMap, HivePrincipal.HivePrincipalType principalType) {
        if (privilegesMap != null && !privilegesMap.isEmpty()) {
            for (TSentryPrivilegeMap map : privilegesMap.values()) {
                Map principalNameToPrivilegeMap = map.getPrivilegeMap();
                for (String principalName : principalNameToPrivilegeMap.keySet()) {
                    for (TSentryPrivilege priv : (Set)principalNameToPrivilegeMap.get(principalName)) {
                        infoList.add(SentryAuthorizerUtil.convert2HivePrivilegeInfo(priv, new HivePrincipal(principalName, principalType)));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCurrentRole(String roleName) throws HiveAccessControlException, HiveAuthzPluginException {
        try {
            this.sentryClient = this.getSentryClient();
            this.hiveAuthzBinding = new HiveAuthzBinding(this.hiveHook, this.conf, this.authzConf);
            this.hiveAuthzBinding.setActiveRoleSet(roleName, this.sentryClient.listUserRoles(this.authenticator.getUserName()));
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.GRANT_ROLE;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (Exception e) {
            String msg = "Error when sentryClient setCurrentRole: " + e.getMessage();
            this.executeOnErrorHooks(msg, e);
        }
        finally {
            this.closeClient();
            if (this.hiveAuthzBinding != null) {
                this.hiveAuthzBinding.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        List<String> roles = new ArrayList<String>();
        try {
            this.sentryClient = this.getSentryClient();
            this.hiveAuthzBinding = new HiveAuthzBinding(this.hiveHook, this.conf, this.authzConf);
            ActiveRoleSet roleSet = this.hiveAuthzBinding.getActiveRoleSet();
            if (roleSet.isAll()) {
                roles = this.convert2RoleList(this.sentryClient.listUserRoles(this.authenticator.getUserName()));
            } else {
                roles.addAll(roleSet.getRoles());
            }
        }
        catch (Exception e) {
            String msg = "Error when sentryClient listUserRoles: " + e.getMessage();
            this.executeOnErrorHooks(msg, e);
        }
        finally {
            this.closeClient();
            if (this.hiveAuthzBinding != null) {
                this.hiveAuthzBinding.close();
            }
        }
        return roles;
    }

    @Override
    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException {
        throw new HiveAuthzPluginException("Not supported of SHOW_ROLE_PRINCIPALS in Sentry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAccessControlException, HiveAuthzPluginException {
        ArrayList<HiveRoleGrant> hiveRoleGrants = new ArrayList<HiveRoleGrant>();
        try {
            this.sentryClient = this.getSentryClient();
            Set roles = null;
            if (principal.getType() != HivePrincipal.HivePrincipalType.GROUP) {
                String msg = "Sentry does not allow privileges to be shown for: " + principal.getType();
                throw new HiveAuthzPluginException(msg);
            }
            roles = this.sentryClient.listRolesByGroupName(this.authenticator.getUserName(), principal.getName());
            if (roles != null && !roles.isEmpty()) {
                for (TSentryRole role : roles) {
                    hiveRoleGrants.add(SentryAuthorizerUtil.convert2HiveRoleGrant(role));
                }
            }
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = HiveOperation.SHOW_ROLE_GRANT;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient listRolesByGroupName: " + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
        return hiveRoleGrants;
    }

    @Override
    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) throws HiveAuthzPluginException {
        if (this.ctx.getClientType() != HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2 || !hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            throw new HiveAuthzPluginException("Sentry only supports hiveserver2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantOrRevokePrivlegeOnRole(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, boolean grantOption, boolean isGrant) throws HiveAuthzPluginException, HiveAccessControlException {
        try {
            this.sentryClient = this.getSentryClient();
            for (HivePrincipal principal : hivePrincipals) {
                if (principal.getType() != HivePrincipal.HivePrincipalType.ROLE) {
                    String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principal.getType();
                    throw new HiveAuthzPluginException(msg);
                }
                for (HivePrivilege privilege : hivePrivileges) {
                    String grantorName = this.authenticator.getUserName();
                    String roleName = principal.getName();
                    String action = SentryAuthorizerUtil.convert2SentryAction(privilege);
                    List columnNames = privilege.getColumns();
                    Boolean grantOp = null;
                    if (isGrant) {
                        grantOp = grantOption;
                    }
                    switch (hivePrivObject.getType()) {
                        case GLOBAL: {
                            if (isGrant) {
                                this.sentryClient.grantServerPrivilege(grantorName, roleName, hivePrivObject.getObjectName(), action, grantOp);
                                break;
                            }
                            this.sentryClient.revokeServerPrivilege(grantorName, roleName, hivePrivObject.getObjectName(), action, grantOp);
                            break;
                        }
                        case DATABASE: {
                            if (isGrant) {
                                this.sentryClient.grantDatabasePrivilege(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), action, grantOp);
                                break;
                            }
                            this.sentryClient.revokeDatabasePrivilege(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), action, grantOp);
                            break;
                        }
                        case TABLE_OR_VIEW: {
                            String msg;
                            if (columnNames != null && !columnNames.isEmpty()) {
                                if (!action.equalsIgnoreCase("select")) {
                                    msg = "Sentry does not support privilege: " + privilege.getName() + " on Column";
                                    throw new HiveAuthzPluginException(msg);
                                }
                                if (isGrant) {
                                    this.sentryClient.grantColumnsPrivileges(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), hivePrivObject.getObjectName(), columnNames, action, grantOp);
                                    break;
                                }
                                this.sentryClient.revokeColumnsPrivilege(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), hivePrivObject.getObjectName(), columnNames, action, grantOp);
                                break;
                            }
                            if (action.equalsIgnoreCase("create")) {
                                msg = "Sentry does not support privilege: " + privilege.getName() + " on Table";
                                throw new HiveAuthzPluginException(msg);
                            }
                            if (isGrant) {
                                this.sentryClient.grantTablePrivilege(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), hivePrivObject.getObjectName(), action, grantOp);
                                break;
                            }
                            this.sentryClient.revokeTablePrivilege(grantorName, roleName, this.serverName, hivePrivObject.getDbname(), hivePrivObject.getObjectName(), action, grantOp);
                            break;
                        }
                        case LOCAL_URI: 
                        case DFS_URI: {
                            if (StringUtils.isBlank((CharSequence)hivePrivObject.getObjectName())) {
                                throw new HiveAuthzPluginException("Null or Empty locations not supported by " + hivePrivObject.getType().name());
                            }
                            String uRIString = hivePrivObject.getObjectName().replace("'", "").replace("\"", "");
                            if (isGrant) {
                                this.sentryClient.grantURIPrivilege(grantorName, roleName, this.serverName, uRIString, grantOp);
                                break;
                            }
                            this.sentryClient.revokeURIPrivilege(grantorName, roleName, this.serverName, uRIString, grantOp);
                            break;
                        }
                        case FUNCTION: 
                        case PARTITION: 
                        case COLUMN: 
                        case COMMAND_PARAMS: {
                            throw new HiveAuthzPluginException(hivePrivObject.getType().name() + " are not supported in sentry");
                        }
                    }
                }
            }
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = isGrant ? HiveOperation.GRANT_PRIVILEGE : HiveOperation.REVOKE_PRIVILEGE;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient grant/revoke privilege:" + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantOrRevokeRoleOnGroup(List<HivePrincipal> hivePrincipals, List<String> roles, HivePrincipal grantorPrinc, boolean isGrant) throws HiveAuthzPluginException, HiveAccessControlException {
        try {
            this.sentryClient = this.getSentryClient();
            HashSet groups = Sets.newHashSet();
            for (HivePrincipal principal : hivePrincipals) {
                if (principal.getType() == HivePrincipal.HivePrincipalType.GROUP) {
                    groups.add(principal.getName());
                    continue;
                }
                String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principal.getType();
                throw new HiveAuthzPluginException(msg);
            }
            for (String roleName : roles) {
                if (isGrant) {
                    if (groups.size() <= 0) continue;
                    this.sentryClient.grantRoleToGroups(grantorPrinc.getName(), roleName, (Set)groups);
                    continue;
                }
                if (groups.size() <= 0) continue;
                this.sentryClient.revokeRoleFromGroups(grantorPrinc.getName(), roleName, (Set)groups);
            }
        }
        catch (SentryAccessDeniedException e) {
            HiveOperation hiveOp = isGrant ? HiveOperation.GRANT_ROLE : HiveOperation.REVOKE_ROLE;
            this.executeOnFailureHooks(hiveOp, e);
        }
        catch (SentryUserException e) {
            String msg = "Error when sentryClient grant/revoke role:" + e.getMessage();
            this.executeOnErrorHooks(msg, (Exception)((Object)e));
        }
        finally {
            this.closeClient();
        }
    }

    private void executeOnFailureHooks(HiveOperation hiveOp, SentryAccessDeniedException e) throws HiveAccessControlException {
        SentryOnFailureHookContextImpl hookCtx = new SentryOnFailureHookContextImpl("", null, null, hiveOp, null, null, null, null, this.authenticator.getUserName(), null, new AuthorizationException((Throwable)e), (Configuration)this.authzConf);
        SentryAuthorizerUtil.executeOnFailureHooks((SentryOnFailureHookContext)hookCtx, (Configuration)this.authzConf);
        throw new HiveAccessControlException(e.getMessage(), (Throwable)e);
    }

    private void executeOnErrorHooks(String msg, Exception e) throws HiveAuthzPluginException {
        LOG.error(msg, (Throwable)e);
        throw new HiveAuthzPluginException(msg, (Throwable)e);
    }

    private List<String> convert2RoleList(Set<TSentryRole> roleSet) {
        ArrayList<String> roles = new ArrayList<String>();
        if (roleSet != null && !roleSet.isEmpty()) {
            for (TSentryRole tRole : roleSet) {
                roles.add(tRole.getRoleName());
            }
        }
        return roles;
    }

    private SentryPolicyServiceClient getSentryClient() throws HiveAuthzPluginException {
        try {
            Preconditions.checkNotNull((Object)this.authzConf, (Object)"HiveAuthConf cannot be null");
            return SentryServiceClientFactory.create((Configuration)this.authzConf);
        }
        catch (Exception e) {
            String msg = "Error occurred when creating Sentry client: " + e.getMessage();
            throw new HiveAuthzPluginException(msg, (Throwable)e);
        }
    }

    private void closeClient() {
        if (this.sentryClient != null) {
            try {
                this.sentryClient.close();
            }
            catch (Exception e) {
                LOG.error("Error while closing the connection with sentry server", (Throwable)e);
            }
        }
    }
}

