/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Joiner;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.SessionStateUserAuthenticator;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContext;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.authz.HiveAuthzBindingHookBase;
import org.apache.sentry.binding.hive.authz.SentryHiveAuthorizerFactory;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;

public class HiveAuthzBindingSessionHook
implements HiveSessionHook {
    public static final String SEMANTIC_HOOK = HiveAuthzBindingHook.class.getName();
    public static final String SCRATCH_DIR_PERMISSIONS = "700";
    public static final String ACCESS_RESTRICT_LIST = Joiner.on((String)",").join((Object)HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, (Object)HiveConf.ConfVars.PREEXECHOOKS.varname, new Object[]{HiveConf.ConfVars.SCRATCHDIR.varname, HiveConf.ConfVars.LOCALSCRATCHDIR.varname, HiveConf.ConfVars.METASTOREURIS.varname, HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, HiveConf.ConfVars.HADOOPBIN.varname, HiveConf.ConfVars.HIVESESSIONID.varname, HiveConf.ConfVars.HIVEAUXJARS.varname, HiveConf.ConfVars.SCRATCHDIRPERMISSION.varname, HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.varname, HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY.varname, HiveConf.ConfVars.HIVERELOADABLEJARS.varname, "hive.access.conf.url", "hive.sentry.conf.url", "hive.access.subject.name", "hive.sentry.subject.name", "hive.sentry.active.role.set"});
    public static final String WILDCARD_ACL_VALUE = "*";

    public void run(HiveSessionHookContext sessionHookContext) throws HiveSQLException {
        HiveConf sessionConf = sessionHookContext.getSessionConf();
        this.appendConfVar(sessionConf, HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, SEMANTIC_HOOK);
        HiveAuthzConf authzConf = HiveAuthzBindingHookBase.loadAuthzConf(sessionConf);
        String commandWhitelist = authzConf.get("hive.sentry.security.command.whitelist", "set,reset,reload");
        sessionConf.setVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST, commandWhitelist);
        sessionConf.setVar(HiveConf.ConfVars.SCRATCHDIRPERMISSION, SCRATCH_DIR_PERMISSIONS);
        sessionConf.setBoolVar(HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY, true);
        sessionConf.set("hive.access.subject.name", sessionHookContext.getSessionUser());
        sessionConf.set("hive.sentry.subject.name", sessionHookContext.getSessionUser());
        this.updateJobACL(sessionConf, "mapreduce.job.acl-view-job", sessionHookContext.getSessionUser());
        this.updateJobACL(sessionConf, "mapreduce.job.acl-modify-job", sessionHookContext.getSessionUser());
        sessionConf.addToRestrictList(ACCESS_RESTRICT_LIST);
        sessionConf.setBoolean(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED.varname, true);
        sessionConf.set(HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER.varname, SessionStateUserAuthenticator.class.getName());
        sessionConf.set(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER.varname, SentryHiveAuthorizerFactory.class.getName());
    }

    private void appendConfVar(HiveConf sessionConf, String confVar, String sentryConfVal) {
        String currentValue = sessionConf.get(confVar, "").trim();
        currentValue = currentValue.isEmpty() ? sentryConfVal : sentryConfVal + "," + currentValue;
        sessionConf.set(confVar, currentValue);
    }

    private void updateJobACL(HiveConf sessionConf, String aclName, String sessionUser) {
        String aclString = sessionConf.get(aclName, "");
        if (aclString.isEmpty()) {
            aclString = sessionUser;
        } else if (aclString.startsWith(" ")) {
            aclString = sessionUser + aclString;
        } else {
            boolean isWildcard;
            boolean bl = isWildcard = aclString.contains(WILDCARD_ACL_VALUE) && aclString.trim().equals(WILDCARD_ACL_VALUE);
            if (!isWildcard) {
                aclString = sessionUser + "," + aclString;
            }
        }
        sessionConf.set(aclName, aclString.trim());
    }
}

