/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.Locale;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.ValueScaler;

class CommentText
implements RrdGraphConstants {
    protected final String text;
    String resolvedText;
    String marker;
    boolean enabled;
    int x;
    int y;

    CommentText(String text) {
        this.text = text;
    }

    void resolveText(Locale l, DataProcessor dproc, ValueScaler valueScaler) {
        this.resolvedText = this.text;
        this.marker = "";
        if (this.resolvedText != null) {
            for (String someMarker : MARKERS) {
                if (!this.resolvedText.endsWith(someMarker)) continue;
                this.marker = someMarker;
                this.resolvedText = this.resolvedText.substring(0, this.resolvedText.length() - this.marker.length());
                this.trimIfGlue();
                break;
            }
        }
        this.enabled = this.resolvedText != null;
    }

    void trimIfGlue() {
        if (this.marker.equals("\\g")) {
            this.resolvedText = this.resolvedText.replaceFirst("\\s+$", "");
        }
    }

    boolean isPrint() {
        return false;
    }

    boolean isValidGraphElement() {
        return !this.isPrint() && this.enabled;
    }
}

